/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.jcr;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.vault.davex.DAVExRepositoryFactory;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.RepositoryFactory;
import org.apache.sling.ide.impl.vlt.Activator;
import org.apache.sling.ide.transport.RepositoryInfo;

public abstract class RepositoryUtils {
    private static final Object SYNC = new Object();
    static final String[] WEBDAV_URL_LOCATIONS = new String[]{"server/default/jcr:root", "crx/server/crx.default/jcr:root"};
    private static final RepositoryFactory FACTORY = new DAVExRepositoryFactory();
    private static final Map<RepositoryAddress, Repository> REGISTERED_REPOSITORIES = new HashMap<RepositoryAddress, Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository getRepository(RepositoryInfo repositoryInfo) throws RepositoryException {
        RepositoryAddress repositoryAddress = RepositoryUtils.getRepositoryAddress(repositoryInfo);
        Object object = SYNC;
        synchronized (object) {
            return REGISTERED_REPOSITORIES.get(repositoryAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryAddress getRepositoryAddress(RepositoryInfo repositoryInfo) {
        StringBuilder errors = new StringBuilder();
        String[] stringArray = WEBDAV_URL_LOCATIONS;
        int n = WEBDAV_URL_LOCATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String webDavUrlLocation = stringArray[n2];
            Session session = null;
            String url = repositoryInfo.appendPath(webDavUrlLocation);
            try {
                Repository repository;
                RepositoryAddress address = new RepositoryAddress(url);
                Object object = SYNC;
                synchronized (object) {
                    repository = REGISTERED_REPOSITORIES.get(address);
                    if (repository == null) {
                        Set supportedSchemes = FACTORY.getSupportedSchemes();
                        if (!supportedSchemes.contains(address.getURI().getScheme())) {
                            throw new IllegalArgumentException("Unable to create a a repository for " + address.getURI() + ", since the scheme is unsupported. Only schemes '" + supportedSchemes + "' are supported");
                        }
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(Repository.class.getClassLoader());
                        try {
                            repository = FACTORY.createRepository(address);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                        REGISTERED_REPOSITORIES.put(address, repository);
                    }
                }
                session = repository.login((Credentials)new SimpleCredentials(repositoryInfo.getUsername(), repositoryInfo.getPassword().toCharArray()));
                RepositoryAddress repositoryAddress = address;
                return repositoryAddress;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (RepositoryException e) {
                Activator.getDefault().getPluginLogger().trace("Failed connecting to repository at " + url, (Throwable)e);
                errors.append(url).append(" : ").append(e.getMessage()).append('\n');
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            ++n2;
        }
        errors.deleteCharAt(errors.length() - 1);
        throw new IllegalArgumentException("No repository found at " + repositoryInfo.getUrl() + "\n" + errors.toString());
    }

    public static Credentials getCredentials(RepositoryInfo repositoryInfo) {
        return new SimpleCredentials(repositoryInfo.getUsername(), repositoryInfo.getPassword().toCharArray());
    }

    private RepositoryUtils() {
    }
}

