/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.serialization;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.impl.io.XmlAnalyzer;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.RepositoryProvider;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.ide.impl.vlt.VaultFsLocator;
import org.apache.sling.ide.impl.vlt.serialization.ContentXmlHandler;
import org.apache.sling.ide.impl.vlt.serialization.VltSerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.transport.ResourceProxy;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VltSerializationManager
implements SerializationManager {
    static final String EXTENSION_XML = ".xml";
    private VltSerializationDataBuilder builder;

    public static void main(String[] args) throws RepositoryException, URISyntaxException, IOException {
        VaultFile vaultFile;
        String attempt;
        String[] attempts;
        RepositoryAddress address = new RepositoryAddress("http://localhost:8080/server/root");
        Repository repo = new RepositoryProvider().getRepository(address);
        Session session = repo.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
        VaultFileSystem fs = Mounter.mount(null, null, (RepositoryAddress)address, (String)"/", (Session)session);
        String[] stringArray = attempts = new String[]{"/rep:policy", "/var"};
        int n = attempts.length;
        int n2 = 0;
        while (n2 < n) {
            attempt = stringArray[n2];
            vaultFile = fs.getFile(attempt);
            System.out.println(String.valueOf(attempt) + " -> " + vaultFile);
            ++n2;
        }
        stringArray = attempts;
        n = attempts.length;
        n2 = 0;
        while (n2 < n) {
            attempt = stringArray[n2];
            attempt = String.valueOf(PlatformNameFormat.getPlatformPath((String)attempt)) + EXTENSION_XML;
            vaultFile = fs.getFile(attempt);
            System.out.println(String.valueOf(attempt) + " -> " + vaultFile);
            ++n2;
        }
    }

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSerializationFile(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        if (fileName.equals(".content.xml")) {
            return true;
        }
        if (!fileName.endsWith(EXTENSION_XML)) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                SerializationType serType = XmlAnalyzer.analyze((InputSource)new InputSource(in));
                return serType == SerializationType.XML_DOCVIEW;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBaseResourcePath(String serializationFilePath) {
        File file = new File(serializationFilePath);
        String fileName = file.getName();
        if (fileName.equals(".content.xml")) {
            return file.getParent();
        }
        if (!fileName.endsWith(EXTENSION_XML)) {
            return file.getAbsolutePath();
        }
        if (!file.exists()) {
            return this.getPathWithoutXmlExtension(file);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                String string;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                try {
                    SerializationType serType = XmlAnalyzer.analyze((InputSource)new InputSource(in));
                    if (serType == SerializationType.XML_DOCVIEW) {
                        string = this.getPathWithoutXmlExtension(file);
                        return string;
                    }
                    return file.getAbsolutePath();
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (in == null) return string;
                    ((InputStream)in).close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPathWithoutXmlExtension(File file) {
        return file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - EXTENSION_XML.length());
    }

    public String getSerializationFilePath(String baseFilePath, SerializationKind serializationKind) {
        switch (serializationKind) {
            case FOLDER: 
            case METADATA_PARTIAL: {
                return String.valueOf(baseFilePath) + File.separatorChar + ".content.xml";
            }
            case METADATA_FULL: {
                return baseFilePath;
            }
            case FILE: {
                return String.valueOf(baseFilePath) + ".dir" + File.separatorChar + ".content.xml";
            }
        }
        throw new IllegalArgumentException("Unsupported serialization kind " + serializationKind);
    }

    public String getRepositoryPath(String osPath) {
        String repositoryPath;
        String name = Text.getName((String)osPath);
        if (name.equals(".content.xml")) {
            String parentPath = Text.getRelativeParent((String)osPath, (int)1);
            if (parentPath != null && parentPath.endsWith(".dir")) {
                parentPath = parentPath.substring(0, parentPath.length() - ".dir".length());
            }
            repositoryPath = PlatformNameFormat.getRepositoryPath((String)parentPath);
        } else {
            repositoryPath = osPath.endsWith(EXTENSION_XML) ? PlatformNameFormat.getRepositoryPath((String)osPath.substring(0, osPath.length() - EXTENSION_XML.length())) : PlatformNameFormat.getRepositoryPath((String)osPath).replace(".dir/", "/");
        }
        if (repositoryPath.length() > 0 && repositoryPath.charAt(0) != '/') {
            repositoryPath = String.valueOf('/') + repositoryPath;
        } else if (repositoryPath.length() == 0) {
            repositoryPath = "/";
        }
        return repositoryPath;
    }

    public String getOsPath(String repositoryPath) {
        return PlatformNameFormat.getPlatformPath((String)repositoryPath);
    }

    protected void bindVaultFsLocator(VaultFsLocator fsLocator) {
        this.getBuilder().setLocator(fsLocator);
    }

    protected void unbindVaultFsLocator(VaultFsLocator fsLocator) {
        this.getBuilder().setLocator(null);
    }

    private VltSerializationDataBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new VltSerializationDataBuilder();
        }
        return this.builder;
    }

    public SerializationDataBuilder newBuilder(org.apache.sling.ide.transport.Repository repository, File contentSyncRoot) throws SerializationException {
        VltSerializationDataBuilder b = this.getBuilder();
        b.init(repository, contentSyncRoot);
        return b;
    }

    public ResourceProxy readSerializationData(String filePath, InputStream source) throws IOException {
        if (source == null) {
            return null;
        }
        String repositoryPath = this.getRepositoryPath(filePath);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            ContentXmlHandler handler = new ContentXmlHandler(repositoryPath);
            parser.parse(source, (DefaultHandler)handler);
            return handler.getRoot();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }
}

