/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.filter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterResult;

public class VltFilter
implements Filter {
    private DefaultWorkspaceFilter filter;

    public VltFilter(InputStream in) throws IOException, ConfigurationException {
        if (in != null) {
            this.filter = new DefaultWorkspaceFilter();
            this.filter.load(in);
        } else {
            this.filter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
    }

    public FilterResult filter(String relativeFilePath) {
        if (relativeFilePath.length() > 0 && relativeFilePath.charAt(0) != '/') {
            relativeFilePath = String.valueOf('/') + relativeFilePath;
        }
        if (this.filter.contains(relativeFilePath)) {
            return FilterResult.ALLOW;
        }
        for (PathFilterSet pathFilterSet : this.filter.getFilterSets()) {
            if (!pathFilterSet.getRoot().startsWith(relativeFilePath)) continue;
            return FilterResult.PREREQUISITE;
        }
        return FilterResult.DENY;
    }
}

