/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.ide.impl.vlt.VltRepository;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryFactory;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.osgi.service.event.EventAdmin;

public class VltRepositoryFactory
implements RepositoryFactory {
    private EventAdmin eventAdmin;
    private Map<String, VltRepository> repositoryMap = new HashMap<String, VltRepository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(RepositoryInfo repositoryInfo, boolean acceptsDisconnectedRepository) throws RepositoryException {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository repo;
            block5: {
                repo = this.repositoryMap.get(key);
                if (repo != null) break block5;
                return null;
            }
            if (!repo.isDisconnected() || acceptsDisconnectedRepository) {
                return repo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository connectRepository(RepositoryInfo repositoryInfo) throws RepositoryException {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository repo = this.repositoryMap.get(key);
            if (repo != null && !repo.isDisconnected()) {
                return repo;
            }
            repo = new VltRepository(repositoryInfo, this.eventAdmin);
            repo.connect();
            this.repositoryMap.put(key, repo);
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRepository(RepositoryInfo repositoryInfo) {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository r = this.repositoryMap.get(key);
            if (r != null) {
                r.disconnected();
            }
        }
    }

    private String getKey(RepositoryInfo repositoryInfo) {
        return String.valueOf(repositoryInfo.getUsername()) + ":" + repositoryInfo.getPassword() + "@" + repositoryInfo.getUrl();
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }
}

