/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import org.apache.sling.ide.impl.vlt.Activator;
import org.apache.sling.ide.impl.vlt.AddOrUpdateNodeCommand;
import org.apache.sling.ide.impl.vlt.DeleteNodeCommand;
import org.apache.sling.ide.impl.vlt.GetNodeCommand;
import org.apache.sling.ide.impl.vlt.GetNodeContentCommand;
import org.apache.sling.ide.impl.vlt.ListChildrenCommand;
import org.apache.sling.ide.impl.vlt.ListTreeCommand;
import org.apache.sling.ide.impl.vlt.ReorderChildNodesCommand;
import org.apache.sling.ide.impl.vlt.VltNodeTypeRegistry;
import org.apache.sling.ide.jcr.RepositoryUtils;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandContext;
import org.apache.sling.ide.transport.FileInfo;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.transport.TracingCommand;
import org.osgi.service.event.EventAdmin;

public class VltRepository
implements org.apache.sling.ide.transport.Repository {
    private final RepositoryInfo repositoryInfo;
    private EventAdmin eventAdmin;
    private NodeTypeRegistry ntRegistry;
    private Repository jcrRepo;
    private Credentials credentials;
    private boolean disconnected = false;
    private final Logger logger;

    public VltRepository(RepositoryInfo repositoryInfo, EventAdmin eventAdmin) {
        this.repositoryInfo = repositoryInfo;
        this.eventAdmin = eventAdmin;
        this.logger = Activator.getDefault().getPluginLogger();
    }

    public synchronized void disconnected() {
        this.disconnected = true;
    }

    public synchronized boolean isDisconnected() {
        return this.disconnected;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public void connect() {
        try {
            this.jcrRepo = RepositoryUtils.getRepository(this.repositoryInfo);
            this.credentials = RepositoryUtils.getCredentials(this.repositoryInfo);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RuntimeException(e);
        }
        this.loadNodeTypeRegistry();
    }

    private void loadNodeTypeRegistry() {
        try {
            this.ntRegistry = new VltNodeTypeRegistry(this);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Command<Void> newAddOrUpdateNodeCommand(CommandContext context, FileInfo fileInfo, ResourceProxy resource, Repository.CommandExecutionFlag ... flags) {
        return TracingCommand.wrap((Command)new AddOrUpdateNodeCommand(this.jcrRepo, this.credentials, context, fileInfo, resource, this.logger, flags), (EventAdmin)this.eventAdmin);
    }

    public Command<Void> newReorderChildNodesCommand(ResourceProxy resource) {
        return TracingCommand.wrap((Command)new ReorderChildNodesCommand(this.jcrRepo, this.credentials, resource, this.logger), (EventAdmin)this.eventAdmin);
    }

    public Command<Void> newDeleteNodeCommand(String path) {
        return TracingCommand.wrap((Command)new DeleteNodeCommand(this.jcrRepo, this.credentials, path, this.logger), (EventAdmin)this.eventAdmin);
    }

    public Command<ResourceProxy> newListChildrenNodeCommand(String path) {
        return TracingCommand.wrap((Command)new ListChildrenCommand(this.jcrRepo, this.credentials, path, this.logger), (EventAdmin)this.eventAdmin);
    }

    public Command<ResourceProxy> newGetNodeContentCommand(String path) {
        return TracingCommand.wrap((Command)new GetNodeContentCommand(this.jcrRepo, this.credentials, path, this.logger), (EventAdmin)this.eventAdmin);
    }

    public Command<byte[]> newGetNodeCommand(String path) {
        return TracingCommand.wrap((Command)new GetNodeCommand(this.jcrRepo, this.credentials, path, this.logger), (EventAdmin)this.eventAdmin);
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    Command<ResourceProxy> newListTreeNodeCommand(String path, int levels) {
        return TracingCommand.wrap((Command)new ListTreeCommand(this.jcrRepo, this.credentials, path, levels, this.eventAdmin, this.logger), (EventAdmin)this.eventAdmin);
    }

    public synchronized NodeTypeRegistry getNodeTypeRegistry() {
        if (this.repositoryInfo == null) {
            throw new IllegalStateException("repositoryInfo must not be null");
        }
        return this.ntRegistry;
    }
}

