/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.ResourceProxy;

public class ReorderChildNodesCommand
extends JcrCommand<Void> {
    private final ResourceProxy resource;

    public ReorderChildNodesCommand(Repository repository, Credentials credentials, ResourceProxy resource, Logger logger) {
        super(repository, credentials, resource.getPath(), logger, new Repository.CommandExecutionFlag[0]);
        this.resource = resource;
    }

    @Override
    protected Void execute0(Session session) throws RepositoryException, IOException {
        boolean nodeExists = session.nodeExists(this.getPath());
        if (!nodeExists) {
            return null;
        }
        Node node = session.getNode(this.getPath());
        NodeType primaryNodeType = node.getPrimaryNodeType();
        if (primaryNodeType.hasOrderableChildNodes()) {
            this.reorderChildNodes(node, this.resource);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void reorderChildNodes(Node nodeToReorder, ResourceProxy resourceToReorder) throws RepositoryException {
        children = resourceToReorder.getChildren();
        childrenIterator = children.listIterator();
        if (!childrenIterator.hasNext()) {
            this.getLogger().trace("Resource at {0} has no children, skipping child node reordering", new Object[]{resourceToReorder.getPath()});
            return;
        }
        resourceChildNames = new HashSet<String>(children.size());
        nodeChildNames = new HashSet<String>(children.size());
        nodeChildren = new LinkedList<Node>();
        nodeChildrenIt = nodeToReorder.getNodes();
        while (nodeChildrenIt.hasNext()) {
            node = nodeChildrenIt.nextNode();
            nodeChildren.add(node);
            nodeChildNames.add(node.getName());
        }
        for (ResourceProxy childResources : children) {
            resourceChildNames.add(Text.getName((String)childResources.getPath()));
        }
        nodeChildrenListIt = nodeChildren.listIterator();
        this.traceResourcesAndNodes(children, nodeChildren);
        if (resourceChildNames.equals(nodeChildNames)) ** GOTO lbl43
        this.getLogger().warn("Different child names between the local workspace ( " + resourceChildNames + ") and the repository (" + nodeChildNames + ") for path " + this.resource.getPath() + ". Reordering will not be performed");
        return;
lbl-1000:
        // 1 sources

        {
            childResource = (ResourceProxy)childrenIterator.next();
            childNode = (Node)nodeChildrenListIt.next();
            if (Text.getName((String)childResource.getPath()).equals(childNode.getName())) {
                if (!resourceToReorder.covers(childResource.getPath())) continue;
                this.reorderChildNodes(childNode, childResource);
                continue;
            }
            if (!nodeToReorder.getPrimaryNodeType().hasOrderableChildNodes()) {
                this.getLogger().trace("Node at {0} does not have orderable child nodes, skipping reordering of {1}", new Object[]{nodeToReorder.getPath(), childResource.getPath()});
                continue;
            }
            if (childrenIterator.hasNext()) {
                expectedParentName = Text.getName((String)((ResourceProxy)childrenIterator.next()).getPath());
                childrenIterator.previous();
            } else {
                expectedParentName = null;
            }
            this.getLogger().trace("For node at {0} ordering {1} before {2}", new Object[]{nodeToReorder.getPath(), Text.getName((String)childResource.getPath()), expectedParentName});
            nodeToReorder.orderBefore(Text.getName((String)childResource.getPath()), expectedParentName);
lbl43:
            // 5 sources

            ** while (childrenIterator.hasNext() || nodeChildrenListIt.hasNext())
        }
lbl44:
        // 1 sources

    }

    private void traceResourcesAndNodes(List<ResourceProxy> children, List<Node> nodeChildren) throws RepositoryException {
        StringBuilder out = new StringBuilder();
        out.append("Comparison of nodes and resources before reordering \n");
        out.append(" === Resources === \n");
        int i = 0;
        while (i < children.size()) {
            out.append(String.format("%3d. %s%n", i, children.get(i).getPath()));
            ++i;
        }
        out.append(" === Nodes === \n");
        i = 0;
        while (i < nodeChildren.size()) {
            out.append(String.format("%3d. %s%n", i, nodeChildren.get(i).getPath()));
            ++i;
        }
        this.getLogger().trace(out.toString(), new Object[0]);
    }

    @Override
    public Command.Kind getKind() {
        return Command.Kind.REORDER_CHILDREN;
    }
}

