/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.ide.impl.vlt.ConversionUtils;
import org.apache.sling.ide.impl.vlt.JcrResult;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.transport.Result;

public abstract class JcrCommand<T>
implements Command<T> {
    private final Credentials credentials;
    private final Repository repository;
    private final String path;
    private final Logger logger;
    private final EnumSet<Repository.CommandExecutionFlag> flags;

    public JcrCommand(Repository repository, Credentials credentials, String path, Logger logger, Repository.CommandExecutionFlag ... flags) {
        this.repository = repository;
        this.credentials = credentials;
        this.path = path;
        this.logger = logger;
        this.flags = EnumSet.noneOf(Repository.CommandExecutionFlag.class);
        this.flags.addAll(Arrays.asList(flags));
    }

    public Result<T> execute() {
        Session session = null;
        try {
            session = this.repository.login(this.credentials);
            T result = this.execute0(session);
            session.save();
            JcrResult<T> jcrResult = JcrResult.success(result);
            return jcrResult;
        }
        catch (LoginException e) {
            JcrResult jcrResult = JcrResult.failure(e);
            return jcrResult;
        }
        catch (RepositoryException e) {
            JcrResult jcrResult = JcrResult.failure(e);
            return jcrResult;
        }
        catch (IOException e) {
            JcrResult jcrResult = JcrResult.failure(e);
            return jcrResult;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected abstract T execute0(Session var1) throws RepositoryException, IOException;

    public String getPath() {
        return this.path;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public Set<Repository.CommandExecutionFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public Command.Kind getKind() {
        return null;
    }

    protected ResourceProxy nodeToResource(Node node) throws RepositoryException {
        ResourceProxy resource = new ResourceProxy(node.getPath());
        resource.addAdapted(Node.class, (Object)node);
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            String propertyName = property.getName();
            Object propertyValue = ConversionUtils.getPropertyValue(property);
            if (propertyValue == null) continue;
            resource.addProperty(propertyName, propertyValue);
        }
        return resource;
    }

    protected void dumpNode(Node node, PrintStream ps) throws RepositoryException {
        this.printNode(node, ps);
        this.writeChildren(node, 1, ps);
    }

    private void printNode(Node node, PrintStream ps) throws RepositoryException {
        ps.println(String.valueOf(node.getName()) + " [" + node.getPrimaryNodeType().getName() + "]");
    }

    private void writeChildren(Node parent, int depth, PrintStream ps) throws RepositoryException {
        NodeIterator it = parent.getNodes();
        while (it.hasNext()) {
            int i = 0;
            while (i < depth) {
                ps.append(' ');
                ++i;
            }
            Node child = it.nextNode();
            this.printNode(child, ps);
            this.writeChildren(child, depth + 1, ps);
        }
    }
}

