/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandContext;
import org.apache.sling.ide.transport.FileInfo;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.util.PathUtil;

public class AddOrUpdateNodeCommand
extends JcrCommand<Void> {
    private ResourceProxy resource;
    private FileInfo fileInfo;
    private CommandContext context;

    public AddOrUpdateNodeCommand(Repository jcrRepo, Credentials credentials, CommandContext context, FileInfo fileInfo, ResourceProxy resource, Logger logger, Repository.CommandExecutionFlag ... flags) {
        super(jcrRepo, credentials, resource.getPath(), logger, flags);
        this.context = context;
        this.fileInfo = fileInfo;
        this.resource = resource;
    }

    @Override
    protected Void execute0(Session session) throws RepositoryException, IOException {
        this.update(this.resource, session);
        return null;
    }

    private void update(ResourceProxy resource, Session session) throws RepositoryException, IOException {
        Node node;
        String path = resource.getPath();
        boolean nodeExists = session.nodeExists(path);
        if (nodeExists) {
            node = session.getNode(path);
            this.getLogger().trace("Found existing node at {0} with primaryType {1}", new Object[]{path, node.getPrimaryNodeType().getName()});
        } else {
            node = this.createNode(resource, session);
            this.getLogger().trace("Created node at {0} with primaryType {1}", new Object[]{path, node.getPrimaryNodeType().getName()});
        }
        if (nodeExists && this.getFlags().contains(Repository.CommandExecutionFlag.CREATE_ONLY_WHEN_MISSING)) {
            return;
        }
        this.updateNode(node, resource);
        this.processDeletedNodes(node, resource);
        for (ResourceProxy child : resource.getCoveredChildren()) {
            this.update(child, session);
        }
    }

    private void processDeletedNodes(Node node, ResourceProxy resource2) throws RepositoryException {
        List resourceChildren = resource2.getChildren();
        if (resourceChildren.size() == 0) {
            this.getLogger().trace("Resource at {0} has no children, skipping deleted nodes processing", new Object[]{resource2.getPath()});
            return;
        }
        HashMap<String, ResourceProxy> resourceChildrenPaths = new HashMap<String, ResourceProxy>(resourceChildren.size());
        for (ResourceProxy child : resourceChildren) {
            resourceChildrenPaths.put(child.getPath(), child);
        }
        NodeIterator it = node.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            if (resourceChildrenPaths.containsKey(child.getPath())) {
                if (!resource2.covers(child.getPath())) continue;
                this.processDeletedNodes(child, (ResourceProxy)resourceChildrenPaths.get(child.getPath()));
                continue;
            }
            if (this.context.filter() != null && this.context.filter().filter(child.getPath()) == FilterResult.DENY) {
                this.getLogger().trace("Not deleting node at {0} since it is not included in the filter", new Object[]{child.getPath()});
                continue;
            }
            this.getLogger().trace("Deleting node {0} as it is no longer present in the local checkout", new Object[]{child.getPath()});
            child.remove();
        }
    }

    private Node createNode(ResourceProxy resource, Session session) throws RepositoryException, FileNotFoundException {
        String parentLocation = Text.getRelativeParent((String)resource.getPath(), (int)1);
        if (parentLocation.isEmpty()) {
            parentLocation = "/";
        }
        if (!session.nodeExists(parentLocation)) {
            throw new RepositoryException("No parent found at " + parentLocation + " ; it's needed to create node at " + resource.getPath());
        }
        String primaryType = (String)resource.getProperties().get("jcr:primaryType");
        Node parent = session.getNode(parentLocation);
        String childName = PathUtil.getName((String)resource.getPath());
        if (primaryType == null) {
            return parent.addNode(childName);
        }
        return parent.addNode(childName, primaryType);
    }

    private void updateNode(Node node, ResourceProxy resource) throws RepositoryException, IOException {
        if (node.getPath().equals(this.getPath()) && this.fileInfo != null) {
            this.updateFileLikeNodeTypes(node);
        }
        HashSet<String> propertiesToRemove = new HashSet<String>();
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isProtected() || property.getDefinition().isAutoCreated() || property.getDefinition().getRequiredType() == 2) continue;
            propertiesToRemove.add(property.getName());
        }
        propertiesToRemove.removeAll(resource.getProperties().keySet());
        Session session = node.getSession();
        Object mixinTypes = resource.getProperties().get("jcr:mixinTypes");
        if (mixinTypes != null) {
            this.updateMixins(node, mixinTypes);
        }
        for (String propertyToRemove : propertiesToRemove) {
            node.getProperty(propertyToRemove).remove();
            this.getLogger().trace("Removed property {0} from node at {1}", new Object[]{propertyToRemove, node.getPath()});
        }
        String primaryType = (String)resource.getProperties().get("jcr:primaryType");
        if (primaryType != null && !node.getPrimaryNodeType().getName().equals(primaryType) && node.getDepth() != 0) {
            node.setPrimaryType(primaryType);
            session.save();
            this.getLogger().trace("Set new primary type {0} for node at {1}", new Object[]{primaryType, node.getPath()});
        }
        for (Map.Entry entry : resource.getProperties().entrySet()) {
            Object[] arguments;
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            Property property = null;
            if ("jcr:mixinTypes".equals(propertyName)) continue;
            if (node.hasProperty(propertyName)) {
                property = node.getProperty(propertyName);
            }
            if (property != null && property.getDefinition().isProtected()) continue;
            ValueFactory valueFactory = session.getValueFactory();
            Value value = null;
            Value[] values = null;
            if (propertyValue instanceof String) {
                value = valueFactory.createValue((String)propertyValue);
                this.ensurePropertyDefinitionMatchers(property, 1, false);
            } else if (propertyValue instanceof String[]) {
                values = this.toValueArray((String[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 1, true);
            } else if (propertyValue instanceof Boolean) {
                value = valueFactory.createValue(((Boolean)propertyValue).booleanValue());
                this.ensurePropertyDefinitionMatchers(property, 6, false);
            } else if (propertyValue instanceof Boolean[]) {
                values = this.toValueArray((Boolean[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 6, true);
            } else if (propertyValue instanceof Calendar) {
                value = valueFactory.createValue((Calendar)propertyValue);
                this.ensurePropertyDefinitionMatchers(property, 5, false);
            } else if (propertyValue instanceof Calendar[]) {
                values = this.toValueArray((Calendar[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 5, true);
            } else if (propertyValue instanceof Double) {
                value = valueFactory.createValue(((Double)propertyValue).doubleValue());
                this.ensurePropertyDefinitionMatchers(property, 4, false);
            } else if (propertyValue instanceof Double[]) {
                values = this.toValueArray((Double[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 4, true);
            } else if (propertyValue instanceof BigDecimal) {
                value = valueFactory.createValue((BigDecimal)propertyValue);
                this.ensurePropertyDefinitionMatchers(property, 12, false);
            } else if (propertyValue instanceof BigDecimal[]) {
                values = this.toValueArray((BigDecimal[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 12, true);
            } else if (propertyValue instanceof Long) {
                value = valueFactory.createValue(((Long)propertyValue).longValue());
                this.ensurePropertyDefinitionMatchers(property, 3, false);
            } else if (propertyValue instanceof Long[]) {
                values = this.toValueArray((Long[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 3, true);
            } else if (propertyValue instanceof UUID) {
                Node reference = session.getNodeByIdentifier(((UUID)propertyValue).toString());
                value = valueFactory.createValue(reference);
                this.ensurePropertyDefinitionMatchers(property, 9, false);
            } else if (propertyValue instanceof UUID[]) {
                values = this.toValueArray((UUID[])propertyValue, session);
                this.ensurePropertyDefinitionMatchers(property, 9, true);
            } else {
                throw new IllegalArgumentException("Unable to handle value '" + propertyValue + "' for property '" + propertyName + "'");
            }
            if (value != null) {
                arguments = new Object[]{propertyName, value, propertyValue, node.getPath()};
                this.getLogger().trace("Setting property {0} with value {1} (raw =  {2}) on node at {3}", arguments);
                node.setProperty(propertyName, value);
                this.getLogger().trace("Set property {0} with value {1} (raw =  {2}) on node at {3}", arguments);
                continue;
            }
            if (values != null) {
                arguments = new Object[]{propertyName, values, propertyValue, node.getPath()};
                this.getLogger().trace("Setting property {0} with values {1} (raw =  {2}) on node at {3}", arguments);
                node.setProperty(propertyName, values);
                this.getLogger().trace("Set property {0} with values {1} (raw =  {2}) on node at {3}", arguments);
                continue;
            }
            throw new IllegalArgumentException("Unable to extract a value or a value array for property '" + propertyName + "' with value '" + propertyValue + "'");
        }
    }

    private void ensurePropertyDefinitionMatchers(Property property, int expectedType, boolean expectedMultiplicity) throws RepositoryException {
        if (property == null) {
            return;
        }
        PropertyDefinition definition = property.getDefinition();
        if (definition.getRequiredType() != expectedType && definition.getRequiredType() != 0) {
            this.getLogger().trace("Removing property {0} of type {1} since we need type {2}", new Object[]{property.getName(), definition.getRequiredType(), expectedType});
            property.remove();
            return;
        }
        if (definition.isMultiple() != expectedMultiplicity) {
            this.getLogger().trace("Removing property {0} of multiplicity {1} since we need type {2}", new Object[]{property.getName(), definition.isMultiple(), expectedMultiplicity});
            property.remove();
            return;
        }
    }

    private void updateMixins(Node node, Object mixinValue) throws RepositoryException {
        ArrayList<String> newMixins = new ArrayList<String>();
        if (mixinValue instanceof String) {
            newMixins.add((String)mixinValue);
        } else {
            newMixins.addAll(Arrays.asList((String[])mixinValue));
        }
        ArrayList<String> oldMixins = new ArrayList<String>();
        NodeType[] nodeTypeArray = node.getMixinNodeTypes();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType mixinNT = nodeTypeArray[n2];
            oldMixins.add(mixinNT.getName());
            ++n2;
        }
        ArrayList mixinsToAdd = new ArrayList(newMixins);
        mixinsToAdd.removeAll(oldMixins);
        ArrayList mixinsToRemove = new ArrayList(oldMixins);
        mixinsToRemove.removeAll(newMixins);
        for (String mixinToAdd : mixinsToAdd) {
            node.addMixin(mixinToAdd);
            this.getLogger().trace("Added new mixin {0} to node at path {1}", new Object[]{mixinToAdd, node.getPath()});
        }
        for (String mixinToRemove : mixinsToRemove) {
            node.removeMixin(mixinToRemove);
            this.getLogger().trace("Removed mixin {0} from node at path {1}", new Object[]{mixinToRemove, node.getPath()});
        }
    }

    private void updateFileLikeNodeTypes(Node node) throws RepositoryException, IOException {
        File file = new File(this.fileInfo.getLocation());
        if (!this.hasFileLikePrimaryNodeType(node)) {
            return;
        }
        Node contentNode = node.hasNode("jcr:content") ? node.getNode("jcr:content") : (node.getProperty("jcr:primaryType").getString().equals("nt:resource") ? node : node.addNode("jcr:content", "nt:resource"));
        this.getLogger().trace("Updating {0} property on node at {1} ", new Object[]{"jcr:data", contentNode.getPath()});
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            Binary binary = node.getSession().getValueFactory().createBinary((InputStream)inputStream);
            contentNode.setProperty("jcr:data", binary);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean hasFileLikePrimaryNodeType(Node node) throws RepositoryException {
        return this.hasPrimaryNodeType(node, "nt:file", "nt:resource");
    }

    private boolean hasPrimaryNodeType(Node node, String ... nodeTypeNames) throws RepositoryException {
        String primaryNodeTypeName = node.getPrimaryNodeType().getName();
        String[] stringArray = nodeTypeNames;
        int n = nodeTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeTypeName = stringArray[n2];
            if (primaryNodeTypeName.equals(nodeTypeName)) {
                return true;
            }
            ++n2;
        }
        stringArray = node.getPrimaryNodeType().getSupertypes();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String supertype = stringArray[n2];
            String superTypeName = supertype.getName();
            String[] stringArray2 = nodeTypeNames;
            int n3 = nodeTypeNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String nodeTypeName = stringArray2[n4];
                if (superTypeName.equals(nodeTypeName)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private Value[] toValueArray(String[] strings, Session session) throws RepositoryException {
        Value[] values = new Value[strings.length];
        int i = 0;
        while (i < strings.length) {
            values[i] = session.getValueFactory().createValue(strings[i]);
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(Boolean[] booleans, Session session) throws RepositoryException {
        Value[] values = new Value[booleans.length];
        int i = 0;
        while (i < booleans.length) {
            values[i] = session.getValueFactory().createValue(booleans[i].booleanValue());
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(Calendar[] calendars, Session session) throws RepositoryException {
        Value[] values = new Value[calendars.length];
        int i = 0;
        while (i < calendars.length) {
            values[i] = session.getValueFactory().createValue(calendars[i]);
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(Double[] doubles, Session session) throws RepositoryException {
        Value[] values = new Value[doubles.length];
        int i = 0;
        while (i < doubles.length) {
            values[i] = session.getValueFactory().createValue(doubles[i].doubleValue());
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(BigDecimal[] bigDecimals, Session session) throws RepositoryException {
        Value[] values = new Value[bigDecimals.length];
        int i = 0;
        while (i < bigDecimals.length) {
            values[i] = session.getValueFactory().createValue(bigDecimals[i]);
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(Long[] longs, Session session) throws RepositoryException {
        Value[] values = new Value[longs.length];
        int i = 0;
        while (i < longs.length) {
            values[i] = session.getValueFactory().createValue(longs[i].longValue());
            ++i;
        }
        return values;
    }

    private Value[] toValueArray(UUID[] uuids, Session session) throws RepositoryException {
        Value[] values = new Value[uuids.length];
        int i = 0;
        while (i < uuids.length) {
            Node reference = session.getNodeByIdentifier(uuids[i].toString());
            values[i] = session.getValueFactory().createValue(reference);
            ++i;
        }
        return values;
    }

    @Override
    public Command.Kind getKind() {
        return Command.Kind.ADD_OR_UPDATE;
    }
}

