/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.apache.sling.ide.eclipse.m2e.internal.AbstractBundleProjectConfigurator;
import org.apache.sling.ide.log.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;

public class MavenBundlePluginProjectConfigurator
extends AbstractBundleProjectConfigurator {
    private static final String MAVEN_BUNDLE_PLUGIN_KEY = "org.apache.felix:maven-bundle-plugin";
    private static final String M2E_TYCHO_EXTENSION_PROJECT_CONFIGURATOR_ID = "maven-bundle-plugin";

    public MavenBundlePluginProjectConfigurator() {
        super(false);
    }

    @Override
    protected boolean isSupportingM2eIncrementalBuild(MavenProject mavenProject, Logger logger) {
        Plugin bundlePlugin = mavenProject.getPlugin(MAVEN_BUNDLE_PLUGIN_KEY);
        if (bundlePlugin == null) {
            logger.warn("maven-bundle-plugin not configured!");
            return false;
        }
        if (LifecycleMappingFactory.createProjectConfigurator((String)M2E_TYCHO_EXTENSION_PROJECT_CONFIGURATOR_ID) != null) {
            logger.trace("Project configurator with id 'maven-bundle-plugin' found -> m2e-tycho installed.", new Object[0]);
            return true;
        }
        String version = bundlePlugin.getVersion();
        if (version == null) {
            logger.warn("Could not retrieve used version of maven-bundle-plugin!");
            return false;
        }
        ComparableVersion comparableVersion = new ComparableVersion(version);
        if (comparableVersion.compareTo(new ComparableVersion("3.2.0")) >= 0) {
            for (PluginExecution pluginExecution : bundlePlugin.getExecutions()) {
                if (!pluginExecution.getGoals().contains("manifest")) continue;
                Xpp3Dom configuration = (Xpp3Dom)pluginExecution.getConfiguration();
                Xpp3Dom supportIncrementalBuildConfiguration = configuration.getChild("supportIncrementalBuild");
                Xpp3Dom exportScrConfiguration = configuration.getChild("exportScr");
                if (supportIncrementalBuildConfiguration == null || !Boolean.parseBoolean(supportIncrementalBuildConfiguration.getValue())) {
                    logger.warn("Although using maven-bundle-plugin in a version >= 3.2.0, the incremental build support was not enabled.");
                    continue;
                }
                if (exportScrConfiguration == null || !Boolean.parseBoolean(exportScrConfiguration.getValue())) {
                    logger.warn("Although using maven-bundle-plugin in a version >= 3.2.0 with incremental build support enabled, component descriptors are not exported (exportScr=false) .");
                    continue;
                }
                logger.trace("Using maven-bundle-plugin in a version >= 3.2.0 with the incremental build support correctly enabled.", new Object[0]);
                return true;
            }
        } else {
            logger.warn("maven-bundle-plugin in a version < 3.2.0 does not natively support incremental builds.");
        }
        return false;
    }
}

