/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.ResourceUtil;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.ResourceAndInfo;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationKindManager;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandContext;
import org.apache.sling.ide.transport.FileInfo;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.util.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResourceChangeCommandFactory {
    private final Set<String> ignoredFileNames;
    private final SerializationManager serializationManager;

    public ResourceChangeCommandFactory(SerializationManager serializationManager, Set<String> ignoredFileNames) {
        this.serializationManager = serializationManager;
        this.ignoredFileNames = ignoredFileNames;
    }

    public Command<?> newCommandForAddedOrUpdated(Repository repository, IResource addedOrUpdated) throws CoreException {
        try {
            return this.addFileCommand(repository, addedOrUpdated);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed updating " + addedOrUpdated, (Throwable)e));
        }
    }

    private Command<?> addFileCommand(Repository repository, IResource resource) throws CoreException, IOException {
        ResourceAndInfo rai = this.buildResourceAndInfo(resource, repository);
        if (rai == null) {
            return null;
        }
        CommandContext context = new CommandContext(ProjectUtil.loadFilter(resource.getProject()));
        if (rai.isOnlyWhenMissing()) {
            return repository.newAddOrUpdateNodeCommand(context, rai.getInfo(), rai.getResource(), new Repository.CommandExecutionFlag[]{Repository.CommandExecutionFlag.CREATE_ONLY_WHEN_MISSING});
        }
        return repository.newAddOrUpdateNodeCommand(context, rai.getInfo(), rai.getResource(), new Repository.CommandExecutionFlag[0]);
    }

    public ResourceAndInfo buildResourceAndInfo(IResource resource, Repository repository) throws CoreException, IOException {
        ResourceProxy resourceProxy;
        Filter filter;
        FileInfo info;
        block21: {
            IFolder folder;
            IResource contentXml;
            if (this.ignoredFileNames.contains(resource.getName())) {
                return null;
            }
            Long modificationTimestamp = (Long)resource.getSessionProperty(ResourceUtil.QN_IMPORT_MODIFICATION_TIMESTAMP);
            if (modificationTimestamp != null && modificationTimestamp >= resource.getModificationStamp()) {
                Activator.getDefault().getPluginLogger().trace("Change for resource {0} ignored as the import timestamp {1} >= modification timestamp {2}", new Object[]{resource, modificationTimestamp, resource.getModificationStamp()});
                return null;
            }
            if (resource.isTeamPrivateMember(512)) {
                Activator.getDefault().getPluginLogger().trace("Skipping team-private resource {0}", new Object[]{resource});
                return null;
            }
            info = this.createFileInfo(resource);
            Activator.getDefault().getPluginLogger().trace("For {0} built fileInfo {1}", new Object[]{resource, info});
            File syncDirectoryAsFile = ProjectUtil.getSyncDirectoryFullPath(resource.getProject()).toFile();
            IFolder syncDirectory = ProjectUtil.getSyncDirectory(resource.getProject());
            filter = ProjectUtil.loadFilter(resource.getProject());
            resourceProxy = null;
            if (this.serializationManager.isSerializationFile(resource.getLocation().toOSString())) {
                IFile file = (IFile)resource;
                try {
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (InputStream contents = file.getContents();){
                        String resourceLocation = file.getFullPath().makeRelativeTo(syncDirectory.getFullPath()).toPortableString();
                        resourceProxy = this.serializationManager.readSerializationData(resourceLocation, contents);
                        this.normaliseResourceChildren(file, resourceProxy, syncDirectory, repository);
                        String primaryType = (String)resourceProxy.getProperties().get("jcr:primaryType");
                        if ("nt:file".equals(primaryType)) {
                            File locationFile = new File(info.getLocation());
                            String locationFileParent = locationFile.getParent();
                            int endIndex = locationFileParent.length() - ".dir".length();
                            File actualFile = new File(locationFileParent.substring(0, endIndex));
                            String newLocation = actualFile.getAbsolutePath();
                            String newName = actualFile.getName();
                            String newRelativeLocation = actualFile.getAbsolutePath().substring(syncDirectoryAsFile.getAbsolutePath().length());
                            info = new FileInfo(newLocation, newRelativeLocation, newName);
                            Activator.getDefault().getPluginLogger().trace("Adjusted original location from {0} to {1}", new Object[]{resourceLocation, newLocation});
                        }
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Status s = new Status(2, "org.apache.sling.ide.eclipse-core", "Failed reading file at " + resource.getFullPath(), (Throwable)e);
                    StatusManager.getManager().handle((IStatus)s, 3);
                    return null;
                }
            }
            if (resource.getType() == 2 && resource.getName().endsWith(".dir") && (contentXml = (folder = (IFolder)resource).findMember(".content.xml")) != null && contentXml.exists() && this.serializationManager.isSerializationFile(contentXml.getLocation().toOSString())) {
                return null;
            }
            resourceProxy = this.buildResourceProxyForPlainFileOrFolder(resource, syncDirectory, repository);
        }
        FilterResult filterResult = this.getFilterResult(resource, resourceProxy, filter);
        switch (filterResult) {
            case ALLOW: {
                return new ResourceAndInfo(resourceProxy, info);
            }
            case PREREQUISITE: {
                if (resourceProxy.getPath().equals("/")) break;
                return new ResourceAndInfo(new ResourceProxy(resourceProxy.getPath()), null, true);
            }
        }
        return null;
    }

    private FileInfo createFileInfo(IResource resource) throws CoreException {
        if (resource.getType() != 1) {
            return null;
        }
        IProject project = resource.getProject();
        IFolder syncFolder = project.getFolder(ProjectUtil.getSyncDirectoryValue(project));
        IPath relativePath = resource.getFullPath().makeRelativeTo(syncFolder.getFullPath());
        FileInfo info = new FileInfo(resource.getLocation().toOSString(), relativePath.toOSString(), resource.getName());
        Activator.getDefault().getPluginLogger().trace("For {0} built fileInfo {1}", new Object[]{resource, info});
        return info;
    }

    private FilterResult getFilterResult(IResource resource, ResourceProxy resourceProxy, Filter filter) {
        if (filter == null) {
            return FilterResult.DENY;
        }
        File contentSyncRoot = ProjectUtil.getSyncDirectoryFile(resource.getProject());
        String repositoryPath = resourceProxy != null ? resourceProxy.getPath() : this.getRepositoryPathForDeletedResource(resource, contentSyncRoot);
        FilterResult filterResult = filter.filter(repositoryPath);
        Activator.getDefault().getPluginLogger().trace("Filter result for {0} for {1}", new Object[]{repositoryPath, filterResult});
        return filterResult;
    }

    private String getRepositoryPathForDeletedResource(IResource resource, File contentSyncRoot) {
        IFolder syncFolder = ProjectUtil.getSyncDirectory(resource.getProject());
        IPath relativePath = resource.getFullPath().makeRelativeTo(syncFolder.getFullPath());
        String absFilePath = new File(contentSyncRoot, relativePath.toOSString()).getAbsolutePath();
        String filePath = this.serializationManager.getBaseResourcePath(absFilePath);
        IPath osPath = Path.fromOSString((String)filePath);
        String repositoryPath = this.serializationManager.getRepositoryPath(osPath.makeRelativeTo(syncFolder.getLocation()).makeAbsolute().toPortableString());
        Activator.getDefault().getPluginLogger().trace("Repository path for deleted resource {0} is {1}", new Object[]{resource, repositoryPath});
        return repositoryPath;
    }

    private ResourceProxy buildResourceProxyForPlainFileOrFolder(IResource changedResource, IFolder syncDirectory, Repository repository) throws CoreException, IOException {
        ResourceProxy dataFromCoveringParent;
        String fallbackNodeType;
        SerializationKind serializationKind;
        if (changedResource.getType() == 1) {
            serializationKind = SerializationKind.FILE;
            fallbackNodeType = "nt:file";
        } else {
            serializationKind = SerializationKind.FOLDER;
            fallbackNodeType = "nt:folder";
        }
        String resourceLocation = String.valueOf('/') + changedResource.getFullPath().makeRelativeTo(syncDirectory.getFullPath()).toPortableString();
        IPath serializationFilePath = Path.fromOSString((String)this.serializationManager.getSerializationFilePath(resourceLocation, serializationKind));
        IResource serializationResource = syncDirectory.findMember(serializationFilePath);
        if (serializationResource == null && changedResource.getType() == 2 && (dataFromCoveringParent = this.findSerializationDataFromCoveringParent(changedResource, syncDirectory, resourceLocation, serializationFilePath)) != null) {
            return dataFromCoveringParent;
        }
        return this.buildResourceProxy(resourceLocation, serializationResource, syncDirectory, fallbackNodeType, repository);
    }

    private ResourceProxy findSerializationDataFromCoveringParent(IResource changedResource, IFolder syncDirectory, String resourceLocation, IPath serializationFilePath) throws CoreException, IOException {
        Logger logger = Activator.getDefault().getPluginLogger();
        logger.trace("Found plain nt:folder candidate at {0}, trying to find a covering resource for it", new Object[]{changedResource.getProjectRelativePath()});
        while (serializationFilePath.segmentCount() != 0) {
            ResourceProxy serializationData;
            IFolder folderWithPossibleSerializationFile = syncDirectory.getFolder(serializationFilePath = serializationFilePath.removeLastSegments(1));
            if (folderWithPossibleSerializationFile == null) {
                logger.trace("No folder found at {0}, moving up to the next level", new Object[]{serializationFilePath});
                continue;
            }
            String possibleSerializationFilePath = this.serializationManager.getSerializationFilePath(folderWithPossibleSerializationFile.getLocation().toOSString(), SerializationKind.METADATA_PARTIAL);
            logger.trace("Looking for serialization data in {0}", new Object[]{possibleSerializationFilePath});
            if (!this.serializationManager.isSerializationFile(possibleSerializationFilePath)) continue;
            IPath parentSerializationFilePath = Path.fromOSString((String)possibleSerializationFilePath).makeRelativeTo(syncDirectory.getLocation());
            IFile possibleSerializationFile = syncDirectory.getFile(parentSerializationFilePath);
            if (!possibleSerializationFile.exists()) {
                logger.trace("Potential serialization data file {0} does not exist, moving up to the next level", new Object[]{possibleSerializationFile.getFullPath()});
                continue;
            }
            Throwable throwable = null;
            Object var12_12 = null;
            try (InputStream contents = possibleSerializationFile.getContents();){
                serializationData = this.serializationManager.readSerializationData(parentSerializationFilePath.toPortableString(), contents);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String repositoryPath = this.serializationManager.getRepositoryPath(resourceLocation);
            String potentialPath = serializationData.getPath();
            boolean covered = serializationData.covers(repositoryPath);
            logger.trace("Found possible serialization data at {0}. Resource :{1} ; our resource: {2}. Covered: {3}", new Object[]{parentSerializationFilePath, potentialPath, repositoryPath, covered});
            if (!covered) break;
            return serializationData.getChild(repositoryPath);
        }
        return null;
    }

    private ResourceProxy buildResourceProxy(String resourceLocation, IResource serializationResource, IFolder syncDirectory, String fallbackPrimaryType, Repository repository) throws CoreException, IOException {
        if (serializationResource instanceof IFile) {
            IFile serializationFile = (IFile)serializationResource;
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream contents = serializationFile.getContents();){
                String serializationFilePath = serializationResource.getFullPath().makeRelativeTo(syncDirectory.getFullPath()).toPortableString();
                ResourceProxy resourceProxy = this.serializationManager.readSerializationData(serializationFilePath, contents);
                this.normaliseResourceChildren(serializationFile, resourceProxy, syncDirectory, repository);
                return resourceProxy;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new ResourceProxy(this.serializationManager.getRepositoryPath(resourceLocation), Collections.singletonMap("jcr:primaryType", fallbackPrimaryType));
    }

    private void normaliseResourceChildren(IFile serializationFile, ResourceProxy resourceProxy, IFolder syncDirectory, Repository repository) throws CoreException {
        try {
            SerializationKindManager skm = new SerializationKindManager();
            skm.init(repository);
            String primaryType = (String)resourceProxy.getProperties().get("jcr:primaryType");
            List<String> mixinTypesList = this.getMixinTypes(resourceProxy);
            SerializationKind serializationKind = skm.getSerializationKind(primaryType, mixinTypesList);
            if (serializationKind == SerializationKind.METADATA_FULL) {
                return;
            }
        }
        catch (RepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed creating a " + SerializationDataBuilder.class.getName(), (Throwable)e));
        }
        IPath serializationDirectoryPath = serializationFile.getFullPath().removeLastSegments(1);
        Iterator childIterator = resourceProxy.getChildren().iterator();
        HashMap<String, IResource> extraChildResources = new HashMap<String, IResource>();
        IResource[] iResourceArray = serializationFile.getParent().members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (!member.equals((Object)serializationFile)) {
                extraChildResources.put(member.getName(), member);
            }
            ++n2;
        }
        while (childIterator.hasNext()) {
            ResourceProxy child = (ResourceProxy)childIterator.next();
            String childName = PathUtil.getName((String)child.getPath());
            String osPath = this.serializationManager.getOsPath(childName);
            extraChildResources.remove(osPath);
            if (resourceProxy.covers(child.getPath())) continue;
            IPath childPath = serializationDirectoryPath.append(osPath);
            IResource childResource = ResourcesPlugin.getWorkspace().getRoot().findMember(childPath);
            if (childResource != null) continue;
            Activator.getDefault().getPluginLogger().trace("For resource at with serialization data {0} the serialized child resource at {1} does not exist in the filesystem and will be ignored", new Object[]{serializationFile, childPath});
            childIterator.remove();
        }
        for (IResource extraChildResource : extraChildResources.values()) {
            IPath extraChildResourcePath = extraChildResource.getFullPath().makeRelativeTo(syncDirectory.getFullPath()).makeAbsolute();
            resourceProxy.addChild(new ResourceProxy(this.serializationManager.getRepositoryPath(extraChildResourcePath.toPortableString())));
            Activator.getDefault().getPluginLogger().trace("For resource at with serialization data {0} the found a child resource at {1} which is not listed in the serialized child resources and will be added", new Object[]{serializationFile, extraChildResource});
        }
    }

    private List<String> getMixinTypes(ResourceProxy resourceProxy) {
        Object mixinTypesProp = resourceProxy.getProperties().get("jcr:mixinTypes");
        if (mixinTypesProp == null) {
            return Collections.emptyList();
        }
        if (mixinTypesProp instanceof String) {
            return Collections.singletonList((String)mixinTypesProp);
        }
        return Arrays.asList((String[])mixinTypesProp);
    }

    public Command<?> newCommandForRemovedResources(Repository repository, IResource removed) throws CoreException {
        try {
            return this.removeFileCommand(repository, removed);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed removing" + removed, (Throwable)e));
        }
    }

    private Command<?> removeFileCommand(Repository repository, IResource resource) throws CoreException, IOException {
        IPath serializationFilePath;
        if (resource.isTeamPrivateMember(512)) {
            Activator.getDefault().getPluginLogger().trace("Skipping team-private resource {0}", new Object[]{resource});
            return null;
        }
        if (this.ignoredFileNames.contains(resource.getName())) {
            return null;
        }
        IFolder syncDirectory = ProjectUtil.getSyncDirectory(resource.getProject());
        Filter filter = ProjectUtil.loadFilter(syncDirectory.getProject());
        FilterResult filterResult = this.getFilterResult(resource, null, filter);
        if (filterResult == FilterResult.DENY || filterResult == FilterResult.PREREQUISITE) {
            return null;
        }
        String resourceLocation = this.getRepositoryPathForDeletedResource(resource, ProjectUtil.getSyncDirectoryFile(resource.getProject()));
        ResourceProxy coveringParentData = this.findSerializationDataFromCoveringParent(resource, syncDirectory, resourceLocation, serializationFilePath = Path.fromOSString((String)this.serializationManager.getSerializationFilePath(resourceLocation, SerializationKind.FOLDER)));
        if (coveringParentData != null) {
            Activator.getDefault().getPluginLogger().trace("Found covering resource data ( repository path = {0} ) for resource at {1},  skipping deletion and performing an update instead", new Object[]{coveringParentData.getPath(), resource.getFullPath()});
            FileInfo info = this.createFileInfo(resource);
            return repository.newAddOrUpdateNodeCommand(new CommandContext(filter), info, coveringParentData, new Repository.CommandExecutionFlag[0]);
        }
        return repository.newDeleteNodeCommand(this.serializationManager.getRepositoryPath(resourceLocation));
    }

    public Command<Void> newReorderChildNodesCommand(Repository repository, IResource res) throws CoreException {
        ResourceAndInfo rai;
        block3: {
            try {
                rai = this.buildResourceAndInfo(res, repository);
                if (rai != null && !rai.isOnlyWhenMissing()) break block3;
                return null;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed reordering child nodes for " + res, (Throwable)e));
            }
        }
        return repository.newReorderChildNodesCommand(rai.getResource());
    }
}

