/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.debug.impl;

import java.util.Date;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;

public class Tracer
implements DebugOptionsListener,
Logger {
    private static final long PERF_IGNORE_THRESHOLD = 50L;
    private final Plugin plugin;
    private boolean debugEnabled;
    private boolean consoleEnabled;
    private boolean performanceEnabled;
    private DebugTrace trace;

    public Tracer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void optionsChanged(DebugOptions options) {
        String pluginId = this.plugin.getBundle().getSymbolicName();
        this.debugEnabled = options.getBooleanOption(String.valueOf(pluginId) + "/debug", false);
        this.consoleEnabled = options.getBooleanOption(String.valueOf(pluginId) + "/debug/console", false) && this.debugEnabled;
        this.performanceEnabled = options.getBooleanOption(String.valueOf(pluginId) + "/debug/performance", false) && this.debugEnabled;
        this.trace = options.newDebugTrace(pluginId, this.getClass());
    }

    public void trace(String message, Object ... arguments) {
        if (!this.debugEnabled) {
            return;
        }
        if (arguments.length > 0) {
            message = NLS.bind((String)message, (Object[])arguments);
        }
        this.trace.trace("/debug", message);
        if (this.consoleEnabled) {
            this.writeToConsole(message, null);
        }
    }

    private void writeToConsole(String message, Throwable t) {
        System.out.println("[" + Thread.currentThread().getName() + "] " + new Date() + " " + this.plugin.getBundle().getSymbolicName() + " : " + message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    public void trace(String message, Throwable error) {
        if (!this.debugEnabled) {
            return;
        }
        this.trace.trace("/debug", message, error);
        if (this.consoleEnabled) {
            this.writeToConsole(message, error);
        }
    }

    public void warn(String message) {
        this.logInternal(2, message, null);
    }

    public void warn(String message, Throwable cause) {
        this.logInternal(2, message, cause);
    }

    public void error(String message) {
        this.logInternal(4, message, null);
    }

    public void error(String message, Throwable cause) {
        this.logInternal(4, message, cause);
    }

    public void tracePerformance(String message, long duration, Object ... arguments) {
        if (!this.performanceEnabled) {
            return;
        }
        if (duration < 50L) {
            return;
        }
        if (arguments.length > 0) {
            message = NLS.bind((String)message, (Object[])arguments);
        }
        String fullMessage = String.valueOf(message) + " took " + duration + " ms";
        this.trace.trace("/debug/performance", fullMessage);
        if (this.consoleEnabled) {
            this.writeToConsole(fullMessage, null);
        }
    }

    private void logInternal(int statusCode, String message, Throwable cause) {
        this.plugin.getLog().log((IStatus)new Status(statusCode, this.plugin.getBundle().getSymbolicName(), message, cause));
    }
}

