/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.debug.impl;

import java.text.DateFormat;
import java.util.Date;
import org.apache.sling.ide.log.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TraceCommandExecutionEventsHandler
implements EventHandler {
    private Logger logger;

    public void handleEvent(Event event) {
        Long start = (Long)event.getProperty("timestamp.start");
        Long end = (Long)event.getProperty("timestamp.end");
        String type = (String)event.getProperty("action.type");
        String flags = (String)event.getProperty("action.flags");
        String target = (String)event.getProperty("action.target");
        String result = (String)event.getProperty("result.txt");
        Throwable t = (Throwable)event.getProperty("result.throwable");
        StringBuilder message = new StringBuilder();
        DateFormat format = DateFormat.getDateTimeInstance(1, 1);
        message.append("[").append(format.format(new Date(start))).append("] ").append(type);
        if (flags != null && flags.length() > 0) {
            message.append(" (").append(flags).append(")");
        }
        message.append(" -> ").append(target);
        message.append(" : ").append(result).append(" (").append(end - start).append(" ms)");
        this.logger.trace(message.toString(), t);
    }

    protected void bindLogger(Logger logger) {
        this.logger = logger;
    }

    protected void unbindLogger(Logger logger) {
        if (this.logger == logger) {
            this.logger = null;
        }
    }
}

