/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.SlingLaunchpadServer;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryFactory;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public abstract class ServerUtil {
    private static final int AUTO_PUBLISH_DISABLE = 1;
    private static final int AUTO_PUBLISH_RESOURCE = 2;
    private static final int AUTO_PUBLISH_BUILD = 3;
    private static final String PROP_AUTO_PUBLISH_SETTING = "auto-publish-setting";
    private static final String PROP_AUTO_PUBLISH_TIME = "auto-publish-time";

    public static Repository getDefaultRepository(IProject project) {
        IServer server = ServerUtil.getDefaultServer(project);
        if (server == null) {
            return null;
        }
        try {
            RepositoryFactory repository = Activator.getDefault().getRepositoryFactory();
            try {
                RepositoryInfo repositoryInfo = ServerUtil.getRepositoryInfo(server, (IProgressMonitor)new NullProgressMonitor());
                return repository.getRepository(repositoryInfo, true);
            }
            catch (RuntimeException | URISyntaxException | RepositoryException e) {
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), e));
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting a repository for " + project, (Throwable)e);
            return null;
        }
    }

    private static IServer getDefaultServer(IProject project) {
        IModule module = org.eclipse.wst.server.core.ServerUtil.getModule((IProject)project);
        if (module == null) {
            return null;
        }
        IServer server = ServerCore.getDefaultServer((IModule)module);
        if (server != null) {
            return server;
        }
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        block0: while (i < allServers.length) {
            IServer aServer = allServers[i];
            IModule[] allModules = aServer.getModules();
            int j = 0;
            while (j < allModules.length) {
                IModule aMoudle = allModules[j];
                if (aMoudle.equals(module)) {
                    server = aServer;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return server;
    }

    private static Set<IServer> getAllServers(IProject project) {
        IModule module = org.eclipse.wst.server.core.ServerUtil.getModule((IProject)project);
        if (module == null) {
            return null;
        }
        HashSet<IServer> result = new HashSet<IServer>();
        IServer defaultServer = ServerCore.getDefaultServer((IModule)module);
        if (defaultServer != null) {
            result.add(defaultServer);
        }
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            IServer aServer = allServers[i];
            IModule[] allModules = aServer.getModules();
            int j = 0;
            while (j < allModules.length) {
                IModule aMoudle = allModules[j];
                if (aMoudle.equals(module)) {
                    result.add(aServer);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Repository getConnectedRepository(IServer server, IProgressMonitor monitor) throws CoreException {
        if (server == null) {
            throw new CoreException((IStatus)new Status(2, "org.apache.sling.ide.eclipse-core", "No server available/selected."));
        }
        if (server.getServerState() != 2) {
            throw new CoreException((IStatus)new Status(2, "org.apache.sling.ide.eclipse-core", "Server not started, please start server first."));
        }
        RepositoryFactory repository = Activator.getDefault().getRepositoryFactory();
        try {
            RepositoryInfo repositoryInfo = ServerUtil.getRepositoryInfo(server, monitor);
            return repository.getRepository(repositoryInfo, false);
        }
        catch (RuntimeException | URISyntaxException | RepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), e));
        }
    }

    public static Repository connectRepository(IServer server, IProgressMonitor monitor) throws CoreException {
        RepositoryFactory repository = Activator.getDefault().getRepositoryFactory();
        try {
            RepositoryInfo repositoryInfo = ServerUtil.getRepositoryInfo(server, monitor);
            return repository.connectRepository(repositoryInfo);
        }
        catch (RuntimeException | URISyntaxException | RepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), e));
        }
    }

    public static void stopRepository(IServer server, IProgressMonitor monitor) throws CoreException {
        RepositoryFactory repository = Activator.getDefault().getRepositoryFactory();
        try {
            RepositoryInfo repositoryInfo = ServerUtil.getRepositoryInfo(server, monitor);
            repository.disconnectRepository(repositoryInfo);
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), (Throwable)e));
        }
    }

    public static RepositoryInfo getRepositoryInfo(IServer server, IProgressMonitor monitor) throws URISyntaxException {
        ISlingLaunchpadServer launchpadServer = (ISlingLaunchpadServer)server.loadAdapter(SlingLaunchpadServer.class, monitor);
        ISlingLaunchpadConfiguration configuration = launchpadServer.getConfiguration();
        URI uri = new URI("http", null, server.getHost(), configuration.getPort(), configuration.getContextPath(), null, null);
        return new RepositoryInfo(configuration.getUsername(), configuration.getPassword(), uri.toString());
    }

    private ServerUtil() {
    }

    public static void triggerIncrementalBuild(IResource anyResourceInThatProject, IProgressMonitor monitorOrNull) {
        if (anyResourceInThatProject == null) {
            throw new IllegalArgumentException("anyResourceInThatProject must not be null");
        }
        IProject proj = anyResourceInThatProject.getProject();
        if (proj == null) {
            throw new IllegalStateException("no project found for " + anyResourceInThatProject);
        }
        Set<IServer> servers = ServerUtil.getAllServers(proj);
        if (servers != null) {
            if (monitorOrNull == null) {
                monitorOrNull = new NullProgressMonitor();
            }
            for (IServer server : servers) {
                if (server == null) continue;
                int autoPublishSetting = server.getAttribute(PROP_AUTO_PUBLISH_SETTING, 2);
                server.getAttribute(PROP_AUTO_PUBLISH_TIME, 15);
                if (autoPublishSetting != 2) continue;
                server.publish(1, monitorOrNull);
            }
        }
    }

    public static boolean runsOnLocalhost(IServerWorkingCopy server) {
        return "localhost".equals(server.getHost());
    }
}

