/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterLocator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProjectUtil {
    private static final String PROPERTY_SYNC_ROOT = "org.apache.sling.ide.eclipse-core.content_sync_root";
    private static final String PROPERTY_PROVISIONING_MODEL_DIR = "org.apache.sling.ide.eclipse-core.provisioning_model_dir";
    private static final String PROPERTY_SYNC_ROOT_DEFAULT_VALUE = "jcr_root";
    private static final QualifiedName PROPERTY_SYNC_ROOT_OLD = new QualifiedName("org.apache.sling.ide.eclipse-core", "sync_root");

    public static IFolder getSyncDirectory(IProject project) {
        if (project == null) {
            return null;
        }
        if (!project.isOpen()) {
            return null;
        }
        if (!ProjectHelper.isContentProject(project)) {
            return null;
        }
        IPath syncDirectoryValue = ProjectUtil.getSyncDirectoryValue(project);
        if (syncDirectoryValue == null || syncDirectoryValue.isEmpty()) {
            return null;
        }
        IResource syncDir = project.findMember(syncDirectoryValue);
        if (syncDir == null || !(syncDir instanceof IFolder)) {
            return null;
        }
        return (IFolder)syncDir;
    }

    public static IPath getSyncDirectoryValue(IProject project) {
        String oldValue = null;
        try {
            oldValue = project.getPersistentProperty(PROPERTY_SYNC_ROOT_OLD);
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().trace("Failed retrieving old values for content sync root for project " + project.getName(), (Throwable)e);
        }
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.apache.sling.ide.eclipse-core");
        if (projectNode == null) {
            String value = oldValue != null ? oldValue : PROPERTY_SYNC_ROOT_DEFAULT_VALUE;
            return Path.fromOSString((String)value);
        }
        String value = projectNode.get(PROPERTY_SYNC_ROOT, null);
        if (value == null && oldValue != null) {
            value = oldValue;
            ProjectUtil.setSyncDirectoryPath(project, Path.fromPortableString((String)value));
        }
        if (oldValue != null) {
            try {
                project.setPersistentProperty(PROPERTY_SYNC_ROOT_OLD, null);
            }
            catch (CoreException e) {
                Activator.getDefault().getPluginLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        if (value == null) {
            return Path.fromOSString((String)PROPERTY_SYNC_ROOT_DEFAULT_VALUE);
        }
        return Path.fromPortableString((String)value);
    }

    public static File getSyncDirectoryFile(IProject project) {
        return new File(project.getLocation().toFile(), ProjectUtil.getSyncDirectoryValue(project).toString());
    }

    public static IPath getSyncDirectoryFullPath(IProject project) {
        return project.getFolder(ProjectUtil.getSyncDirectoryValue(project)).getFullPath();
    }

    public static void setSyncDirectoryPath(IProject project, IPath path) {
        ProjectUtil.setPathPersistentProperty(project, path, PROPERTY_SYNC_ROOT);
    }

    private static void setPathPersistentProperty(IProject project, IPath path, String propertyName) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.apache.sling.ide.eclipse-core");
        if (projectNode != null) {
            projectNode.put(propertyName, path.toPortableString());
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                Activator.getDefault().getPluginLogger().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static IPath getProvisioningModelPath(IProject project) {
        if (project == null || !project.isOpen() || !ProjectHelper.isLaunchpadProject(project)) {
            return null;
        }
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.apache.sling.ide.eclipse-core");
        if (projectNode == null) {
            return null;
        }
        String propertyValue = projectNode.get(PROPERTY_PROVISIONING_MODEL_DIR, null);
        if (propertyValue == null) {
            return null;
        }
        return Path.fromPortableString((String)propertyValue);
    }

    public static void setProvisioningModelPath(IProject project, IPath modelPath) {
        ProjectUtil.setPathPersistentProperty(project, modelPath, PROPERTY_PROVISIONING_MODEL_DIR);
    }

    public static Filter loadFilter(IProject project) throws CoreException {
        FilterLocator filterLocator = Activator.getDefault().getFilterLocator();
        IPath filterPath = ProjectUtil.findFilterPath(project);
        if (filterPath == null) {
            return null;
        }
        IFile filterFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filterPath);
        Filter filter = null;
        if (filterFile != null && filterFile.exists()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream contents = filterFile.getContents();){
                    filter = filterLocator.loadFilter(contents);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed loading filter file for project " + project.getName() + " from location " + filterFile, (Throwable)e));
            }
        }
        return filter;
    }

    public static IPath findFilterPath(IProject project) {
        FilterLocator filterLocator = Activator.getDefault().getFilterLocator();
        IFolder syncFolder = ProjectUtil.getSyncDirectory(project);
        if (syncFolder == null) {
            return null;
        }
        File filterLocation = filterLocator.findFilterLocation(syncFolder.getLocation().toFile());
        if (filterLocation == null) {
            return null;
        }
        return Path.fromOSString((String)filterLocation.getAbsolutePath());
    }

    public static boolean isInsideContentSyncRoot(IResource resource) {
        if (resource == null) {
            return false;
        }
        IFolder syncRoot = ProjectUtil.getSyncDirectory(resource.getProject());
        if (syncRoot == null) {
            return false;
        }
        return syncRoot.getFullPath().isPrefixOf(resource.getFullPath());
    }

    private ProjectUtil() {
    }
}

