/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.util;

public class PathUtil {
    public static String join(String first, String second) {
        boolean relativePathHasLeadingSlash;
        boolean repoUrlHasTrailingSlash = first.endsWith("/");
        boolean bl = relativePathHasLeadingSlash = !second.isEmpty() && second.charAt(0) == '/';
        if (repoUrlHasTrailingSlash ^ relativePathHasLeadingSlash) {
            return String.valueOf(first) + second;
        }
        if (!repoUrlHasTrailingSlash && !relativePathHasLeadingSlash) {
            return String.valueOf(first) + '/' + second;
        }
        if (repoUrlHasTrailingSlash && relativePathHasLeadingSlash) {
            return String.valueOf(first) + second.substring(1);
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String getParent(String path) {
        if (path == null || path.length() == 0 || path.charAt(0) != '/' || path.indexOf(47) == -1) {
            throw new IllegalArgumentException("No a valid or absolut path: " + path);
        }
        if (path.equals("/")) {
            return null;
        }
        if (path.lastIndexOf(47) == 0) {
            return "/";
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    public static boolean isAncestor(String ancestor, String child) {
        while ((child = PathUtil.getParent(child)) != null) {
            if (!child.equals(ancestor)) continue;
            return true;
        }
        return false;
    }
}

