/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.sling.ide.transport.Batcher;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.util.PathUtil;

public class DefaultBatcher
implements Batcher {
    private List<Command<?>> queue = new ArrayList();

    @Override
    public void add(Command<?> command) {
        this.queue.add(command);
    }

    @Override
    public List<Command<?>> get() {
        LinkedCommands batched = new LinkedCommands();
        ArrayList result = new ArrayList();
        for (Command<?> cmd : this.queue) {
            boolean accepted = batched.addLinked(cmd);
            if (accepted) continue;
            result.add(cmd);
        }
        result.addAll(0, batched.getReorders());
        result.addAll(0, batched.getUpdates());
        result.addAll(0, batched.getDeletes());
        this.queue.clear();
        return result;
    }

    private static class LinkedCommands {
        private List<Command<?>> deletes = new ArrayList();
        private List<Command<?>> updates = new ArrayList();
        private List<Command<?>> reorders = new ArrayList();

        private LinkedCommands() {
        }

        public boolean addLinked(Command<?> newCmd) {
            if (newCmd.getKind() == null) {
                return false;
            }
            switch (newCmd.getKind()) {
                case DELETE: {
                    this.processDelete(newCmd);
                    return true;
                }
                case ADD_OR_UPDATE: {
                    this.processWithPathEqualityCheck(newCmd, this.updates);
                    return true;
                }
                case REORDER_CHILDREN: {
                    this.processWithPathEqualityCheck(newCmd, this.reorders);
                    return true;
                }
            }
            return false;
        }

        private void processDelete(Command<?> newCmd) {
            String path = newCmd.getPath();
            ListIterator<Command<?>> iterator = this.deletes.listIterator();
            while (iterator.hasNext()) {
                Command<?> oldCmd = iterator.next();
                if (PathUtil.isAncestor(oldCmd.getPath(), path)) {
                    return;
                }
                if (!PathUtil.isAncestor(path, oldCmd.getPath())) continue;
                iterator.set(newCmd);
                return;
            }
            this.deletes.add(newCmd);
        }

        private void processWithPathEqualityCheck(Command<?> newCmd, List<Command<?>> oldCmds) {
            String path = newCmd.getPath();
            for (Command<?> oldCmd : oldCmds) {
                if (!path.equals(oldCmd.getPath())) continue;
                return;
            }
            oldCmds.add(newCmd);
        }

        public List<Command<?>> getDeletes() {
            return this.deletes;
        }

        public List<Command<?>> getUpdates() {
            return this.updates;
        }

        public List<Command<?>> getReorders() {
            return this.reorders;
        }
    }
}

