/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.HashMap;
import java.util.Set;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandExecutionProperties;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.Result;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class TracingCommand<T>
implements Command<T> {
    private final Command<T> command;
    private final EventAdmin eventAdmin;

    public static <T> TracingCommand<T> wrap(Command<T> command, EventAdmin eventAdmin) {
        return new TracingCommand<T>(command, eventAdmin);
    }

    public TracingCommand(Command<T> command, EventAdmin eventAdmin) {
        this.command = command;
        this.eventAdmin = eventAdmin;
    }

    @Override
    public Result<T> execute() {
        long start = System.currentTimeMillis();
        Result<T> result = this.command.execute();
        long end = System.currentTimeMillis();
        if (this.eventAdmin != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("result.txt", result.toString());
            props.put("result.status", result.isSuccess());
            try {
                result.get();
            }
            catch (RepositoryException e) {
                props.put("result.throwable", e);
            }
            props.put("action.type", this.command.getClass().getSimpleName());
            Set<Repository.CommandExecutionFlag> flags = this.command.getFlags();
            if (!flags.isEmpty()) {
                StringBuilder flagsString = new StringBuilder();
                for (Repository.CommandExecutionFlag flag : flags) {
                    flagsString.append((Object)flag).append(',');
                }
                flagsString.deleteCharAt(flagsString.length() - 1);
                props.put("action.flags", flagsString.toString());
            }
            props.put("action.target", this.command.getPath());
            props.put("timestamp.start", start);
            props.put("timestamp.end", end);
            Event event = new Event(CommandExecutionProperties.REPOSITORY_TOPIC, props);
            this.eventAdmin.postEvent(event);
        }
        return result;
    }

    @Override
    public String getPath() {
        return this.command.getPath();
    }

    @Override
    public Set<Repository.CommandExecutionFlag> getFlags() {
        return this.command.getFlags();
    }

    @Override
    public Command.Kind getKind() {
        return this.command.getKind();
    }
}

