/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceProxy {
    private final String path;
    private final Map<String, Object> properties;
    private final List<ResourceProxy> children = new ArrayList<ResourceProxy>();
    private final Map<Class<?>, Object> adapted = new HashMap(1);

    public ResourceProxy(String path) {
        this(path, new HashMap<String, Object>());
    }

    public ResourceProxy(String path, Map<String, Object> properties) {
        this.path = path;
        this.properties = properties;
    }

    public void addChild(ResourceProxy child) {
        if (!this.isParent(this.path, child.getPath())) {
            throw new IllegalArgumentException("Resource at path " + child.getPath() + " is not a direct child of " + this.path);
        }
        this.children.add(child);
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public String getPath() {
        return this.path;
    }

    public List<ResourceProxy> getChildren() {
        return this.children;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> void addAdapted(Class<T> klazz, T adaptedInstance) {
        this.adapted.put(klazz, adaptedInstance);
    }

    public <T> T adaptTo(Class<T> klazz) {
        Object res = this.adapted.get(klazz);
        return (T)res;
    }

    public List<ResourceProxy> getCoveredChildren() {
        ArrayList<ResourceProxy> coveredChildren = new ArrayList<ResourceProxy>();
        for (ResourceProxy child : this.getChildren()) {
            if (child.getProperties().isEmpty()) continue;
            coveredChildren.add(child);
        }
        return coveredChildren;
    }

    public boolean covers(String path) {
        for (ResourceProxy child : this.getCoveredChildren()) {
            if (child.getPath().equals(path)) {
                return true;
            }
            if (!this.isDescendent(child.getPath(), path)) continue;
            return child.covers(path);
        }
        return false;
    }

    private boolean isParent(String parentPath, String childPath) {
        if (!this.isDescendent(parentPath, childPath)) {
            return false;
        }
        int i = parentPath.length() + 1;
        while (i < childPath.length()) {
            if (childPath.charAt(i) == '/') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDescendent(String parentPath, String childPath) {
        if (parentPath.equals("/")) {
            return childPath.length() > 1;
        }
        return parentPath.length() < childPath.length() && childPath.charAt(parentPath.length()) == '/' && childPath.startsWith(parentPath);
    }

    public ResourceProxy getChild(String path) {
        for (ResourceProxy child : this.getChildren()) {
            if (child.getPath().equals(path)) {
                return child;
            }
            if (!this.isDescendent(child.getPath(), path)) continue;
            return child.getChild(path);
        }
        return null;
    }

    public String toString() {
        return this.toString0(1);
    }

    private String toString0(int padding) {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(": path=").append(this.path).append(", properties=").append(this.properties);
        for (ResourceProxy child : this.children) {
            out.append("\n");
            int i = 0;
            while (i < padding * 2) {
                out.append(' ');
                ++i;
            }
            out.append(child.toString0(padding + 1));
        }
        return out.toString();
    }
}

