/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.serialization;

import org.apache.sling.ide.serialization.SerializationKind;

public class SerializationData {
    private final byte[] contents;
    private final String fileName;
    private final SerializationKind serializationKind;
    private final String folderPath;

    public static SerializationData empty(String folderPath, SerializationKind serializationKind) {
        return new SerializationData(folderPath, null, null, serializationKind);
    }

    public SerializationData(String folderPath, String fileName, byte[] contents, SerializationKind serializationKind) {
        this.folderPath = folderPath;
        this.contents = contents;
        this.fileName = fileName;
        this.serializationKind = serializationKind;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SerializationKind getSerializationKind() {
        return this.serializationKind;
    }

    public boolean hasContents() {
        return this.contents != null && this.contents.length > 0;
    }

    public String toString() {
        return "[SerializationData# folderPath: " + this.folderPath + ", fileName: " + this.fileName + ", serializationKind: " + (Object)((Object)this.serializationKind) + ", hasContents: " + this.hasContents() + "]";
    }
}

