/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.osgi.impl;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.osgi.SourceReference;
import org.apache.sling.ide.osgi.impl.MavenSourceReferenceImpl;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.osgi.framework.Version;

public class HttpOsgiClient
implements OsgiClient {
    private static final int DEFAULT_SOCKET_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 30;
    private RepositoryInfo repositoryInfo;

    public HttpOsgiClient(RepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    /*
     * Unable to fully structure code
     */
    static Version getBundleVersionFromReader(String bundleSymbolicName, Reader reader) throws IOException {
        gson = new Gson();
        var3_3 = null;
        var4_5 = null;
        try {
            jsonReader = new JsonReader(reader);
            try {
                jsonReader.beginObject();
                while (true) {
                    name = jsonReader.nextName();
                    if (name.equals("data")) {
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            bundleInfo = (BundleInfo)gson.fromJson(jsonReader, BundleInfo.class);
                            if (!bundleSymbolicName.equals(bundleInfo.getSymbolicName())) continue;
                            return bundleInfo.getVersion();
                        }
                        jsonReader.endArray();
                    }
                    jsonReader.skipValue();
                    break;
                }
            }
            finally {
                if (jsonReader.hasNext()) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public Version getBundleVersion(String bundleSymbolicName) throws OsgiClientException {
        GetMethod method = new GetMethod(this.repositoryInfo.appendPath("system/console/bundles.json"));
        HttpClient client = this.getHttpClient();
        try {
            Version version;
            InputStreamReader reader;
            InputStream input;
            Throwable throwable;
            block24: {
                block23: {
                    int result = client.executeMethod((HttpMethod)method);
                    if (result != 200) {
                        throw new HttpException("Got status code " + result + " for call to " + method.getURI());
                    }
                    throwable = null;
                    Object var6_8 = null;
                    input = method.getResponseBodyAsStream();
                    reader = new InputStreamReader(input, StandardCharsets.US_ASCII);
                    version = HttpOsgiClient.getBundleVersionFromReader(bundleSymbolicName, reader);
                    if (reader == null) break block23;
                    ((Reader)reader).close();
                }
                if (input == null) break block24;
                input.close();
            }
            method.releaseConnection();
            return version;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (input != null) {
                                input.close();
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            try {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new OsgiClientException(e);
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            throw throwable;
        }
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(30000);
        client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.repositoryInfo.getUsername(), this.repositoryInfo.getPassword());
        client.getState().setCredentials(new AuthScope(this.repositoryInfo.getHost(), this.repositoryInfo.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        return client;
    }

    @Override
    public void installBundle(InputStream in, String fileName) throws OsgiClientException {
        if (in == null) {
            throw new IllegalArgumentException("in may not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName may not be null");
        }
        PostMethod filePost = new PostMethod(this.repositoryInfo.appendPath("system/console/install"));
        try {
            try {
                filePost.setRequestHeader("referer", "about:blank");
                ArrayList<Object> partList = new ArrayList<Object>();
                partList.add(new StringPart("action", "install"));
                partList.add(new StringPart("_noredir_", "_noredir_"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)baos);
                ByteArrayPartSource partSource = new ByteArrayPartSource(fileName, baos.toByteArray());
                partList.add(new FilePart("bundlefile", (PartSource)partSource));
                partList.add(new StringPart("bundlestart", "start"));
                Part[] parts = partList.toArray(new Part[partList.size()]);
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
                if (status != 200) {
                    throw new OsgiClientException("Method execution returned status " + status);
                }
            }
            catch (IOException e) {
                throw new OsgiClientException(e);
            }
        }
        finally {
            filePost.releaseConnection();
        }
    }

    @Override
    public void installLocalBundle(final String explodedBundleLocation) throws OsgiClientException {
        if (explodedBundleLocation == null) {
            throw new IllegalArgumentException("explodedBundleLocation may not be null");
        }
        new LocalBundleInstaller(this.getHttpClient(), this.repositoryInfo){

            @Override
            void configureRequest(PostMethod method) {
                method.addParameter("dir", explodedBundleLocation);
            }
        }.installBundle();
    }

    @Override
    public void installLocalBundle(final InputStream jarredBundle, String sourceLocation) throws OsgiClientException {
        if (jarredBundle == null) {
            throw new IllegalArgumentException("jarredBundle may not be null");
        }
        new LocalBundleInstaller(this.getHttpClient(), this.repositoryInfo){

            @Override
            void configureRequest(PostMethod method) throws IOException {
                Part[] parts = new Part[]{new FilePart("bundle", (PartSource)new ByteArrayPartSource("bundle.jar", IOUtils.toByteArray((InputStream)jarredBundle)))};
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            }
        }.installBundle();
    }

    @Override
    public List<SourceReference> findSourceReferences() throws OsgiClientException {
        GetMethod method = new GetMethod(this.repositoryInfo.appendPath("system/sling/tooling/sourceReferences.json"));
        HttpClient client = this.getHttpClient();
        try {
            int result = client.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new HttpException("Got status code " + result + " for call to " + method.getURI());
            }
            List<SourceReference> list = HttpOsgiClient.parseSourceReferences(method.getResponseBodyAsStream());
            return list;
        }
        catch (IOException e) {
            throw new OsgiClientException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    static List<SourceReference> parseSourceReferences(InputStream response) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(response, StandardCharsets.US_ASCII));){
            SourceBundleData[] refs = (SourceBundleData[])new Gson().fromJson(jsonReader, SourceBundleData[].class);
            ArrayList<SourceReference> res = new ArrayList<SourceReference>(refs.length);
            SourceBundleData[] sourceBundleDataArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                SourceBundleData sourceData = sourceBundleDataArray[n2];
                for (SourceReferenceFromJson ref : sourceData.sourceReferences) {
                    if (!ref.isMavenType()) continue;
                    res.add(ref.getMavenSourceReference());
                }
                ++n2;
            }
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final class BundleInfo {
        private String symbolicName;
        private String version;

        private BundleInfo() {
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Version getVersion() {
            return new Version(this.version);
        }
    }

    private static final class BundleInstallerResult {
        private String status;
        private String message;

        private BundleInstallerResult() {
        }

        public boolean hasMessage() {
            return this.message != null && this.message.length() > 0;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccessful() {
            return "OK".equalsIgnoreCase(this.status);
        }
    }

    static abstract class LocalBundleInstaller {
        private final HttpClient httpClient;
        private final RepositoryInfo repositoryInfo;

        public LocalBundleInstaller(HttpClient httpClient, RepositoryInfo repositoryInfo) {
            this.httpClient = httpClient;
            this.repositoryInfo = repositoryInfo;
        }

        void installBundle() throws OsgiClientException {
            PostMethod method = new PostMethod(this.repositoryInfo.appendPath("system/sling/tooling/install"));
            try {
                try {
                    this.configureRequest(method);
                    Gson gson = new Gson();
                    int status = this.httpClient.executeMethod((HttpMethod)method);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(method.getResponseBodyAsStream(), StandardCharsets.UTF_8));){
                        BundleInstallerResult result = null;
                        if (status != 200) {
                            try {
                                result = (BundleInstallerResult)gson.fromJson(jsonReader, BundleInstallerResult.class);
                                if (result.hasMessage()) {
                                    throw new OsgiClientException(result.getMessage());
                                }
                            }
                            catch (JsonParseException jsonParseException) {}
                            throw new OsgiClientException("Method execution returned status " + status);
                        }
                        result = (BundleInstallerResult)gson.fromJson(jsonReader, BundleInstallerResult.class);
                        if (!result.isSuccessful()) {
                            String errorMessage = !result.hasMessage() ? "Bundle deployment failed, please check the Sling logs" : result.getMessage();
                            throw new OsgiClientException(errorMessage);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new OsgiClientException(e);
                }
            }
            finally {
                method.releaseConnection();
            }
        }

        abstract void configureRequest(PostMethod var1) throws IOException;
    }

    private static final class SourceBundleData {
        @SerializedName(value="Bundle-SymbolicName")
        private String bsn;
        @SerializedName(value="Bundle-Version")
        private String version;
        private List<SourceReferenceFromJson> sourceReferences;

        private SourceBundleData() {
        }
    }

    private static final class SourceReferenceFromJson {
        @SerializedName(value="__type__")
        private String type;
        private String groupId;
        private String artifactId;
        private String version;

        private SourceReferenceFromJson() {
        }

        public boolean isMavenType() {
            return "maven".equals(this.type);
        }

        public MavenSourceReferenceImpl getMavenSourceReference() {
            if (!this.isMavenType()) {
                throw new IllegalStateException("The type is not a Maven source reference but a " + this.type);
            }
            return new MavenSourceReferenceImpl(this.groupId, this.artifactId, this.version);
        }
    }
}

