/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.artifacts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class EmbeddedArtifact {
    private final String name;
    private final String version;
    private final URL source;

    public EmbeddedArtifact(String name, String version, URL source) {
        if (name == null) {
            throw new IllegalArgumentException("The name may not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("The version may not be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("The source may not be null");
        }
        this.version = version;
        this.source = source;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOsgiFriendlyVersion() {
        return this.version.replace('-', '.');
    }

    public InputStream openInputStream() throws IOException {
        return this.source.openStream();
    }
}

