/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.util.Map;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDir;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDirManager;
import org.apache.sling.ide.eclipse.ui.nav.model.UpdateHandler;
import org.apache.sling.ide.eclipse.ui.views.JcrCellLabelProvider;
import org.apache.sling.ide.eclipse.ui.views.JcrEditingSupport;
import org.apache.sling.ide.eclipse.ui.views.NewRow;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class JcrPropertiesView
extends ViewPart {
    private static final String TITLE_FONT = "org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle";
    private TableViewer viewer;
    private Action insertAction;
    private Action deleteAction;
    private Action doubleClickAction;
    private Label titleLabel;
    private ISelectionListener listener;
    private Action showInEditorAction;
    private Action pinAction;
    private JcrNode lastInput;
    private Action synchedAction;
    private String lastEditedOldPropertyName;
    private String lastEditedNewPropertyName;
    private JcrEditingSupport.ColumnId lastEditedColumnId;
    private Composite mainControl;
    private IWorkbenchPage page;

    public Control getMainControl() {
        return this.mainControl;
    }

    public void createPartControl(Composite parent) {
        SyncDirManager.registerUpdateListener(new UpdateHandler(){

            @Override
            public void syncDirUpdated(SyncDir syncDir) {
                JcrPropertiesView.this.refreshContent();
            }
        });
        this.mainControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        this.mainControl.setLayout((Layout)gridLayout);
        if (this.getViewSite() != null) {
            this.titleLabel = new Label(this.mainControl, 64);
            this.titleLabel.setText("");
            GridData data = new GridData(768);
            this.titleLabel.setLayoutData((Object)data);
            Label horizontalLine = new Label(this.mainControl, 258);
            data = new GridData(768);
            horizontalLine.setLayoutData((Object)data);
        }
        if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
            FontData[] fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData();
            fontData[0].setHeight(fontData[0].getHeight() + 2);
            JFaceResources.getFontRegistry().put(TITLE_FONT, fontData);
        }
        Font font = JFaceResources.getFont((String)TITLE_FONT);
        if (this.titleLabel != null) {
            this.titleLabel.setFont(font);
        }
        Composite tableParent = new Composite(this.mainControl, 0);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 1);
        tableLayoutData.widthHint = 1;
        tableLayoutData.heightHint = -1;
        tableParent.setLayoutData((Object)tableLayoutData);
        TableColumnLayout tableLayout = new TableColumnLayout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point p = super.computeSize(composite, wHint, hHint, flushCache);
                return new Point(p.x, p.y);
            }
        };
        tableParent.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableParent, 101124);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer), new CellNavigationStrategy());
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                JcrPropertiesView.this.resetLastValueEdited();
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        int features = 122;
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)features);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection iss = (IStructuredSelection)selection;
                    if (iss.isEmpty()) {
                        JcrPropertiesView.this.deleteAction.setEnabled(false);
                    } else {
                        JcrPropertiesView.this.deleteAction.setEnabled(true);
                    }
                } else {
                    JcrPropertiesView.this.deleteAction.setEnabled(false);
                }
            }
        });
        JcrCellLabelProvider clp = new JcrCellLabelProvider(this.viewer);
        TableViewerColumn column0 = new TableViewerColumn(this.viewer, 0);
        column0.getColumn().setText("Name");
        column0.getColumn().setResizable(true);
        column0.getColumn().setWidth(200);
        tableLayout.setColumnData((Widget)column0.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 140));
        TableViewerColumn column1 = new TableViewerColumn(this.viewer, 0);
        column1.getColumn().setText("Type");
        column1.getColumn().setResizable(true);
        column1.getColumn().setWidth(300);
        column1.setLabelProvider((CellLabelProvider)clp);
        tableLayout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 80));
        TableViewerColumn column2 = new TableViewerColumn(this.viewer, 0);
        column2.getColumn().setText("Value");
        column2.getColumn().setResizable(true);
        column2.getColumn().setWidth(300);
        tableLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, 220));
        TableViewerColumn column3 = new TableViewerColumn(this.viewer, 0);
        column3.getColumn().setText("Protected");
        column3.getColumn().setResizable(true);
        column3.getColumn().setWidth(300);
        column3.setLabelProvider((CellLabelProvider)clp);
        tableLayout.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 57));
        TableViewerColumn column4 = new TableViewerColumn(this.viewer, 0);
        column4.getColumn().setText("Mandatory");
        column4.getColumn().setResizable(true);
        column4.getColumn().setWidth(300);
        column4.setLabelProvider((CellLabelProvider)clp);
        tableLayout.setColumnData((Widget)column4.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 62));
        TableViewerColumn column5 = new TableViewerColumn(this.viewer, 0);
        column5.getColumn().setText("Multiple");
        column5.getColumn().setResizable(true);
        column5.getColumn().setWidth(300);
        column5.setLabelProvider((CellLabelProvider)clp);
        tableLayout.setColumnData((Widget)column5.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 82));
        TableViewerColumn column6 = new TableViewerColumn(this.viewer, 0);
        column6.getColumn().setText("Auto Created");
        column6.getColumn().setResizable(true);
        column6.getColumn().setWidth(300);
        column6.setLabelProvider((CellLabelProvider)clp);
        tableLayout.setColumnData((Widget)column6.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 77));
        column0.setLabelProvider((CellLabelProvider)clp);
        column0.setEditingSupport((EditingSupport)new JcrEditingSupport(this, this.viewer, JcrEditingSupport.ColumnId.NAME));
        column1.setLabelProvider((CellLabelProvider)clp);
        column1.setEditingSupport((EditingSupport)new JcrEditingSupport(this, this.viewer, JcrEditingSupport.ColumnId.TYPE));
        column2.setLabelProvider((CellLabelProvider)clp);
        column2.setEditingSupport((EditingSupport)new JcrEditingSupport(this, this.viewer, JcrEditingSupport.ColumnId.VALUE));
        column5.setEditingSupport((EditingSupport)new JcrEditingSupport(this, this.viewer, JcrEditingSupport.ColumnId.MULTIPLE));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.apache.sling.ide.eclipse-ui.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                IStructuredSelection iss;
                Object firstElem;
                if (selection instanceof IStructuredSelection && (firstElem = (iss = (IStructuredSelection)selection).getFirstElement()) instanceof JcrNode) {
                    JcrNode jcrNode = (JcrNode)firstElem;
                    JcrPropertiesView.this.setInput(jcrNode);
                    return;
                }
            }
        };
        if (this.getViewSite() != null) {
            this.getViewSite().getPage().addSelectionListener(this.listener);
            final ISelection selection = this.getViewSite().getPage().getSelection();
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JcrPropertiesView.this.listener.selectionChanged(null, selection);
                }
            });
        }
    }

    void resetLastValueEdited() {
        this.lastEditedOldPropertyName = null;
        this.lastEditedNewPropertyName = null;
        this.lastEditedColumnId = null;
    }

    void setLastValueEdited(String oldPropertyName, String newPropertyName, JcrEditingSupport.ColumnId columnId) {
        this.lastEditedOldPropertyName = oldPropertyName;
        this.lastEditedNewPropertyName = newPropertyName;
        this.lastEditedColumnId = columnId;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.getViewSite().getPage().removeSelectionListener(this.listener);
            this.listener = null;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JcrPropertiesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = this.getSite();
        if (site != null) {
            site.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    private void contributeToActionBars() {
        if (this.getViewSite() != null) {
            IActionBars bars = this.getViewSite().getActionBars();
            this.fillLocalPullDown(bars.getMenuManager());
            this.fillLocalToolBar(bars.getToolBarManager());
        }
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.insertAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.showInEditorAction);
        if (this.pinAction != null) {
            manager.add((IAction)this.pinAction);
        }
        if (this.synchedAction != null) {
            manager.add((IAction)this.synchedAction);
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.insertAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.showInEditorAction);
        if (this.pinAction != null) {
            manager.add((IAction)this.pinAction);
        }
        if (this.synchedAction != null) {
            manager.add((IAction)this.synchedAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.insertAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.showInEditorAction);
        if (this.pinAction != null) {
            manager.add((IAction)this.pinAction);
        }
        if (this.synchedAction != null) {
            manager.add((IAction)this.synchedAction);
        }
    }

    private void makeActions() {
        this.insertAction = new Action(){

            public void run() {
                NewRow newRow = new NewRow();
                JcrPropertiesView.this.viewer.add((Object)newRow);
                JcrPropertiesView.this.viewer.getTable().setTopIndex(JcrPropertiesView.this.viewer.getTable().getItemCount());
                JcrPropertiesView.this.viewer.getTable().select(JcrPropertiesView.this.viewer.getTable().getItemCount() - 1);
                JcrPropertiesView.this.viewer.editElement((Object)newRow, 0);
            }
        };
        this.insertAction.setText("Insert");
        this.insertAction.setToolTipText("Insert a property");
        this.insertAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.deleteAction = new Action(){

            public void run() {
                IStructuredSelection iss;
                Object elem;
                if (JcrPropertiesView.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                ISelection sel = JcrPropertiesView.this.viewer.getSelection();
                if (sel instanceof IStructuredSelection && (elem = (iss = (IStructuredSelection)sel).getFirstElement()) instanceof IPropertyDescriptor) {
                    IPropertyDescriptor pd = (IPropertyDescriptor)elem;
                    JcrNode jcrnode = (JcrNode)JcrPropertiesView.this.viewer.getInput();
                    jcrnode.deleteProperty(pd.getDisplayName());
                    JcrPropertiesView.this.refreshContent();
                }
            }
        };
        this.deleteAction.setText("Delete");
        this.deleteAction.setToolTipText("Delete a proeprty");
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.doubleClickAction = new Action(){

            public void run() {
                JcrPropertiesView.this.viewer.getSelection();
            }
        };
        this.showInEditorAction = new Action(){

            public void run() {
                JcrNode node = (JcrNode)JcrPropertiesView.this.viewer.getInput();
                IFile file = node.getFileForEditor();
                if (file != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)JcrPropertiesView.this.getPage(), (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
        };
        this.showInEditorAction.setText("Show in editor");
        this.showInEditorAction.setToolTipText("Show underlying vault file in editor");
        this.showInEditorAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        if (this.getViewSite() != null) {
            this.pinAction = new Action("pin to selection", 2){

                public void run() {
                    if (!JcrPropertiesView.this.pinAction.isChecked()) {
                        JcrPropertiesView.this.setContentDescription("");
                        JcrPropertiesView.this.setInput(JcrPropertiesView.this.lastInput);
                    } else {
                        JcrPropertiesView.this.setContentDescription("[pinned]");
                    }
                    if (JcrPropertiesView.this.synchedAction != null) {
                        JcrPropertiesView.this.synchedAction.setEnabled(!JcrPropertiesView.this.pinAction.isChecked());
                    }
                }
            };
            this.pinAction.setText("Pin to selection");
            this.pinAction.setToolTipText("Pin this property view to the current selection");
            this.pinAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_PIN_EDITOR"));
            this.pinAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_PIN_EDITOR_DISABLED"));
            this.pinAction.setChecked(false);
            this.synchedAction = new Action("Link with Editor and selection", 2){

                public void run() {
                    JcrPropertiesView.this.pinAction.setEnabled(!JcrPropertiesView.this.synchedAction.isChecked());
                }
            };
            this.synchedAction.setText("Link with Editor and selection");
            this.synchedAction.setToolTipText("Link with Editor and selection");
            this.synchedAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ELCL_SYNCED"));
            this.synchedAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ELCL_SYNCED_DISABLED"));
            this.synchedAction.setChecked(true);
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JcrPropertiesView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void refreshContent() {
        JcrNode jcrnode;
        SyncDir syncDir;
        JcrNode newnode;
        Object input = this.viewer.getInput();
        if (input != null && input instanceof JcrNode && (newnode = (syncDir = (jcrnode = (JcrNode)input).getSyncDir()).getNode(jcrnode.getJcrPath())) != null) {
            this.viewer.setInput((Object)newnode);
            if (this.lastEditedNewPropertyName != null) {
                Object element;
                int i = 0;
                while ((element = this.viewer.getElementAt(i)) != null) {
                    final IPropertyDescriptor pd = (IPropertyDescriptor)element;
                    Map.Entry me = (Map.Entry)pd.getId();
                    String key = (String)me.getKey();
                    if (this.lastEditedNewPropertyName.equals(key)) {
                        int column;
                        if (this.lastEditedColumnId == JcrEditingSupport.ColumnId.NAME) {
                            column = 0;
                        } else if (this.lastEditedColumnId == JcrEditingSupport.ColumnId.TYPE) {
                            column = 1;
                        } else if (this.lastEditedColumnId == JcrEditingSupport.ColumnId.VALUE) {
                            column = 2;
                        } else if (this.lastEditedColumnId == JcrEditingSupport.ColumnId.MULTIPLE) {
                            column = 5;
                        } else {
                            throw new IllegalStateException("Unknown columnId=" + (Object)((Object)this.lastEditedColumnId));
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    JcrPropertiesView.this.viewer.editElement((Object)pd, column);
                                    JcrPropertiesView.this.viewer.cancelEditing();
                                }
                                catch (Exception e) {
                                    Activator.getDefault().getPluginLogger().error("Exception occured on edit/cancel: " + e, (Throwable)e);
                                }
                            }
                        });
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void setInput(JcrNode jcrNode) {
        this.resetLastValueEdited();
        if (this.pinAction != null && this.pinAction.isChecked()) {
            this.lastInput = jcrNode;
        } else {
            if (this.getViewSite() != null && this.synchedAction != null && this.synchedAction.isChecked()) {
                this.getViewSite().getPage().bringToTop((IWorkbenchPart)this);
            }
            this.viewer.setInput((Object)jcrNode);
            if (this.titleLabel != null) {
                this.titleLabel.setText(jcrNode.getJcrPath());
            }
            this.insertAction.setEnabled(!jcrNode.getPrimaryType().equals("nt:folder"));
            this.deleteAction.setEnabled(false);
            this.showInEditorAction.setEnabled(jcrNode.getFileForEditor() != null);
        }
    }

    private IWorkbenchPage getPage() {
        if (this.page != null) {
            return this.page;
        }
        if (this.getViewSite() != null) {
            return this.getViewSite().getPage();
        }
        return null;
    }

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof JcrNode) {
                JcrNode node = (JcrNode)parent;
                Object[] pds = node.getProperties().getPropertyDescriptors();
                return pds;
            }
            return new String[0];
        }
    }
}

