/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Location;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLTokenizer;

final class TolerantXMLTokenizer
extends XMLTokenizer {
    private final String originDetails;

    TolerantXMLTokenizer(XMLSource source, String originDetails) {
        super(source);
        this.originDetails = originDetails;
    }

    protected void parseAttribute(Token token) {
        token.setType(XMLTokenizer.Type.ATTRIBUTE);
        this.parseName("attribute");
        if (this.pos == token.getStartOffset()) {
            throw new XMLParseException("Expected attribute name", this.source, this.pos);
        }
        this.skipWhiteSpace();
        this.expect('=');
        this.skipWhiteSpace();
        char c = '\u0000';
        if (this.pos < this.source.length()) {
            c = this.source.charAt(this.pos);
        }
        if (c != '\'' && c != '\"') {
            throw new XMLParseException("Expected single or double quotes", this.source, this.pos);
        }
        char endChar = c;
        while (true) {
            ++this.pos;
            if (this.pos >= this.source.length()) {
                int i = Math.min(20, this.source.length() - token.getStartOffset());
                throw new XMLParseException("Missing end quote (" + endChar + ") of attribute: " + this.lookAheadForErrorMessage(null, token.getStartOffset(), i), token);
            }
            c = this.source.charAt(this.pos);
            if (c == endChar) break;
            if (c != 60) continue;
            Location l = new Location(this.source, this.pos);
            System.err.println("Illegal character in attribute value: '" + c + "' in " + this.originDetails + " at " + l);
        }
        ++this.pos;
    }
}

