/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import java.util.StringTokenizer;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDirManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;

public class SyncDir
extends JcrNode {
    private final IFolder folder;

    public SyncDir(IFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder must not be null");
        }
        this.folder = folder;
        this.setResource((IResource)folder);
        SyncDirManager.registerNewSyncDir(this);
    }

    @Override
    public int hashCode() {
        return this.folder.hashCode();
    }

    @Override
    protected boolean childShouldNotBeShown(IResource resource) {
        return resource.getType() == 2 && (resource.getName().equals("WEB-INF") || resource.getName().equals("META-INF"));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SyncDir) {
            SyncDir other = (SyncDir)obj;
            return this.folder.equals((Object)other.folder);
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.folder.getProjectRelativePath().toString();
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.folder.getProjectRelativePath().toString()) + "[jcr root]";
    }

    public IFolder getFolder() {
        return this.folder;
    }

    @Override
    public String getName() {
        return "/";
    }

    @Override
    String getJcrPathName() {
        return "/";
    }

    @Override
    public IFile getFileForEditor() {
        return null;
    }

    @Override
    public SyncDir getSyncDir() {
        return this;
    }

    public JcrNode getNode(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        JcrNode node = SyncDirManager.getSyncDirOrNull(this.folder);
        while (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            node.getChildren(true);
            JcrNode child = node.getChild(nodeName);
            if (child == null) {
                return null;
            }
            node = child;
        }
        return node;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public IResource getResourceForImportExport() {
        return this.folder;
    }
}

