/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav;

import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.nav.model.RootFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class BaseRootFolderContentProvider<T extends RootFolder>
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private final Class<T> klazz;

    public BaseRootFolderContentProvider(Class<T> klazz) {
        this.klazz = klazz;
    }

    public boolean hasChildren(Object parentElement) {
        return this.getChildren(parentElement) != null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            T folder = this.findRootFolder(project);
            if (folder != null) {
                return new Object[]{folder};
            }
        } else if (this.klazz.isAssignableFrom(parentElement.getClass())) {
            RootFolder rootFolder = (RootFolder)parentElement;
            try {
                return rootFolder.members();
            }
            catch (CoreException e) {
                Activator.getDefault().getPluginLogger().error("Could not list members of  " + rootFolder, (Throwable)e);
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        IResource resource;
        T rootFolder;
        if (element instanceof IResource && (rootFolder = this.findRootFolder((resource = (IResource)element).getProject())) != null) {
            return rootFolder.findMember(resource.getFullPath());
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    protected abstract T findRootFolder(IProject var1);
}

