/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SlingConsoleEventListener
implements EventHandler {
    private final Object sync = new Object();
    private final Set<Event> delayedEvents = Collections.newSetFromMap(new LinkedHashMap<Event, Boolean>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Event, Boolean> eldest) {
            return this.size() >= 500;
        }
    });
    private MessageConsole slingConsole;
    private IConsoleListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        Object object = this.sync;
        synchronized (object) {
            this.initSlingConsole();
            if (this.slingConsole != null) {
                this.logEvent(event, this.slingConsole);
                return;
            }
            this.delayedEvents.add(event);
            final IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            if (this.listener == null) {
                this.listener = new IConsoleListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void consolesRemoved(IConsole[] consoles) {
                        Object object = SlingConsoleEventListener.this.sync;
                        synchronized (object) {
                            IConsole[] iConsoleArray = consoles;
                            int n = consoles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConsole console = iConsoleArray[n2];
                                if (console.equals(SlingConsoleEventListener.this.slingConsole)) {
                                    SlingConsoleEventListener.this.slingConsole = null;
                                }
                                ++n2;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void consolesAdded(IConsole[] consoles) {
                        Object object = SlingConsoleEventListener.this.sync;
                        synchronized (object) {
                            IConsole[] iConsoleArray = consoles;
                            int n = consoles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConsole console = iConsoleArray[n2];
                                if (console.getType().equals("Sling")) {
                                    SlingConsoleEventListener.this.slingConsole = (MessageConsole)console;
                                    Set set = SlingConsoleEventListener.this.delayedEvents;
                                    synchronized (set) {
                                        Iterator it = SlingConsoleEventListener.this.delayedEvents.iterator();
                                        while (it.hasNext()) {
                                            SlingConsoleEventListener.this.logEvent((Event)it.next(), SlingConsoleEventListener.this.slingConsole);
                                            it.remove();
                                        }
                                    }
                                    consoleManager.removeConsoleListener(SlingConsoleEventListener.this.listener);
                                    SlingConsoleEventListener.this.listener = null;
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                };
                consoleManager.addConsoleListener(this.listener);
            }
        }
    }

    private void initSlingConsole() {
        if (this.slingConsole == null) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            IConsole[] iConsoleArray = consoleManager.getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getType().equals("Sling")) {
                    this.slingConsole = (MessageConsole)console;
                    break;
                }
                ++n2;
            }
        }
    }

    private void logEvent(Event event, MessageConsole console) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (MessageConsoleStream messageStream = console.newMessageStream();){
                Long start = (Long)event.getProperty("timestamp.start");
                Long end = (Long)event.getProperty("timestamp.end");
                String type = (String)event.getProperty("action.type");
                String flags = (String)event.getProperty("action.flags");
                String target = (String)event.getProperty("action.target");
                String result = (String)event.getProperty("result.txt");
                Throwable t = (Throwable)event.getProperty("result.throwable");
                StringBuilder message = new StringBuilder();
                DateFormat format = DateFormat.getDateTimeInstance(1, 1);
                message.append("[").append(format.format(new Date(start))).append("] ").append(type);
                if (flags != null && flags.length() > 0) {
                    message.append(" (").append(flags).append(")");
                }
                message.append(" -> ").append(target);
                message.append(" : ").append(result).append(" (").append(end - start).append(" ms)").append('\n');
                messageStream.write(message.toString());
                if (t != null) {
                    t.printStackTrace(new PrintStream((OutputStream)messageStream));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getPluginLogger().warn("Failed writing to the console", (Throwable)e);
        }
    }
}

