/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.ResourceUtil;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.core.internal.ResourceAndInfo;
import org.apache.sling.ide.eclipse.core.internal.ResourceChangeCommandFactory;
import org.apache.sling.ide.eclipse.core.progress.ProgressUtils;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.filter.IgnoredResources;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationData;
import org.apache.sling.ide.serialization.SerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationKindManager;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.transport.Result;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;

public class ImportRepositoryContentAction {
    private final IServer server;
    private final IPath projectRelativePath;
    private final IProject project;
    private final Logger logger = Activator.getDefault().getPluginLogger();
    private SerializationManager serializationManager;
    private SerializationDataBuilder builder;
    private IgnoredResources ignoredResources;
    private IProgressMonitor monitor;
    private Repository repository;
    private Filter filter;
    private File contentSyncRoot;
    private IFolder contentSyncRootDir;
    private Set<IResource> currentResources;
    private IPath repositoryImportRoot;

    public ImportRepositoryContentAction(IServer server, IPath projectRelativePath, IProject project, SerializationManager serializationManager) throws SerializationException {
        this.server = server;
        this.projectRelativePath = projectRelativePath;
        this.project = project;
        this.serializationManager = serializationManager;
        this.ignoredResources = new IgnoredResources();
        this.currentResources = new HashSet<IResource>();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SerializationException, CoreException {
        monitor.beginTask("Repository import", -1);
        this.monitor = monitor;
        this.repository = ServerUtil.getConnectedRepository((IServer)this.server, (IProgressMonitor)monitor);
        this.builder = this.serializationManager.newBuilder(this.repository, ProjectUtil.getSyncDirectoryFile((IProject)this.project));
        try {
            SerializationKindManager skm = new SerializationKindManager();
            skm.init(this.repository);
        }
        catch (RepositoryException e1) {
            throw new InvocationTargetException(e1);
        }
        this.filter = ProjectUtil.loadFilter((IProject)this.project);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        try {
            try {
                this.contentSyncRootDir = ProjectUtil.getSyncDirectory((IProject)this.project);
                this.repositoryImportRoot = this.projectRelativePath.makeRelativeTo(this.contentSyncRootDir.getProjectRelativePath()).makeAbsolute();
                this.contentSyncRoot = ProjectUtil.getSyncDirectoryFullPath((IProject)this.project).toFile();
                this.readVltIgnoresNotUnderImportRoot(this.contentSyncRootDir, this.repositoryImportRoot);
                ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
                Activator.getDefault().getPluginLogger().trace("Starting import; repository start point is {0}, workspace start point is {1}", new Object[]{this.repositoryImportRoot, this.projectRelativePath});
                this.recordNotIgnoredResources();
                ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
                this.crawlChildrenAndImport(this.repositoryImportRoot.toPortableString());
                this.removeNotIgnoredAndNotUpdatedResources((IProgressMonitor)new NullProgressMonitor());
                ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (this.builder != null) {
                this.builder.destroy();
                this.builder = null;
            }
            monitor.done();
        }
    }

    private void readVltIgnoresNotUnderImportRoot(IFolder syncDir, IPath repositoryImportRoot) throws IOException, CoreException {
        IFolder current = syncDir;
        int i = 0;
        while (i < repositoryImportRoot.segmentCount()) {
            IPath repoPath = current.getProjectRelativePath().makeRelativeTo(syncDir.getProjectRelativePath()).makeAbsolute();
            this.parseIgnoreFiles(current, repoPath.toPortableString());
            current = (IFolder)current.findMember(repositoryImportRoot.segment(i));
            ++i;
        }
    }

    private void recordNotIgnoredResources() throws CoreException {
        final ResourceChangeCommandFactory rccf = new ResourceChangeCommandFactory(this.serializationManager, Activator.getDefault().getPreferences().getIgnoredFileNamesForSync());
        IResource importStartingPoint = this.contentSyncRootDir.findMember(this.repositoryImportRoot);
        if (importStartingPoint == null) {
            return;
        }
        importStartingPoint.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                FilterResult filterResult;
                block6: {
                    ResourceAndInfo rai;
                    block5: {
                        try {
                            rai = rccf.buildResourceAndInfo(resource, ImportRepositoryContentAction.this.repository);
                            if (rai != null) break block5;
                            return true;
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed reading current project's resources", (Throwable)e));
                        }
                    }
                    String repositoryPath = rai.getResource().getPath();
                    filterResult = ImportRepositoryContentAction.this.filter.filter(repositoryPath);
                    if (!ImportRepositoryContentAction.this.ignoredResources.isIgnored(repositoryPath)) break block6;
                    return false;
                }
                if (filterResult == FilterResult.ALLOW) {
                    ImportRepositoryContentAction.this.currentResources.add(resource);
                    return true;
                }
                return false;
            }
        });
        this.logger.trace("Found {0} not ignored local resources", new Object[]{this.currentResources.size()});
    }

    private void removeNotIgnoredAndNotUpdatedResources(IProgressMonitor monitor) throws CoreException {
        this.logger.trace("Found {0} resources to clean up", new Object[]{this.currentResources.size()});
        for (IResource resource : this.currentResources) {
            if (!resource.exists()) continue;
            this.logger.trace("Deleting {0}", new Object[]{resource});
            resource.delete(true, monitor);
        }
    }

    private void crawlChildrenAndImport(String path) throws RepositoryException, CoreException, IOException, SerializationException {
        this.logger.trace("crawlChildrenAndImport({0},  {1}, {2}, {3}", new Object[]{this.repository, path, this.project, this.projectRelativePath});
        ResourceProxy resource = (ResourceProxy)this.executeCommand(this.repository.newListChildrenNodeCommand(path));
        SerializationData serializationData = this.builder.buildSerializationData(this.contentSyncRoot, resource);
        this.logger.trace("For resource at path {0} got serialization data {1}", new Object[]{resource.getPath(), serializationData});
        LinkedList resourceChildren = new LinkedList(resource.getChildren());
        if (serializationData != null) {
            IPath serializationFolderPath = this.contentSyncRootDir.getProjectRelativePath().append(serializationData.getFolderPath());
            block0 : switch (serializationData.getSerializationKind()) {
                case FILE: {
                    byte[] contents = (byte[])this.executeCommand(this.repository.newGetNodeCommand(path));
                    this.createFile(this.project, this.getPathForPlainFileNode(resource, serializationFolderPath), contents);
                    if (!serializationData.hasContents()) break;
                    this.createFolder(this.project, serializationFolderPath);
                    this.createFile(this.project, serializationFolderPath.append(serializationData.getFileName()), serializationData.getContents());
                    Iterator it = resourceChildren.iterator();
                    while (it.hasNext()) {
                        ResourceProxy child = (ResourceProxy)it.next();
                        if (!"nt:resource".equals(child.getProperties().get("jcr:primaryType"))) continue;
                        ResourceProxy reloadedChildResource = (ResourceProxy)this.executeCommand(this.repository.newListChildrenNodeCommand(child.getPath()));
                        this.logger.trace("Skipping direct handling of {0} node at {1} ; will additionally handle {2} direct children", new Object[]{"nt:resource", child.getPath(), reloadedChildResource.getChildren().size()});
                        if (reloadedChildResource.getChildren().size() != 0) {
                            String pathName = Text.getName((String)reloadedChildResource.getPath());
                            pathName = this.serializationManager.getOsPath(pathName);
                            this.createFolder(this.project, serializationFolderPath.append(pathName));
                            for (ResourceProxy grandChild : reloadedChildResource.getChildren()) {
                                this.crawlChildrenAndImport(grandChild.getPath());
                            }
                        }
                        it.remove();
                        break block0;
                    }
                    break;
                }
                case FOLDER: 
                case METADATA_PARTIAL: {
                    IFolder folder = this.createFolder(this.project, serializationFolderPath);
                    this.parseIgnoreFiles(folder, path);
                    if (!serializationData.hasContents()) break;
                    this.createFile(this.project, serializationFolderPath.append(serializationData.getFileName()), serializationData.getContents());
                    break;
                }
                case METADATA_FULL: {
                    if (!serializationData.hasContents()) break;
                    this.createFile(this.project, serializationFolderPath.append(serializationData.getFileName()), serializationData.getContents());
                }
            }
            this.logger.trace("Resource at {0} has children: {1}", new Object[]{resource.getPath(), resourceChildren});
            if (serializationData.getSerializationKind() == SerializationKind.METADATA_FULL) {
                return;
            }
        } else {
            this.logger.trace("No serialization data found for {0}", new Object[]{resource.getPath()});
        }
        ProgressUtils.advance((IProgressMonitor)this.monitor, (int)1);
        for (ResourceProxy child : resourceChildren) {
            FilterResult filterResult;
            if (this.ignoredResources.isIgnored(child.getPath()) || this.filter != null && (filterResult = this.filter.filter(child.getPath())) == FilterResult.DENY) continue;
            this.crawlChildrenAndImport(child.getPath());
        }
    }

    private IPath getPathForPlainFileNode(ResourceProxy resource, IPath serializationFolderPath) {
        String name = this.serializationManager.getOsPath(Text.getName((String)resource.getPath()));
        return serializationFolderPath.removeLastSegments(1).append(name);
    }

    private void parseIgnoreFiles(IFolder folder, String path) throws IOException, CoreException {
        IResource vltIgnore = folder.findMember(".vltignore");
        if (vltIgnore != null && vltIgnore instanceof IFile) {
            this.logger.trace("Found ignore file at {0}", new Object[]{vltIgnore.getFullPath()});
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream contents = ((IFile)vltIgnore).getContents();){
                List ignoreLines = IOUtils.readLines((InputStream)contents);
                for (String ignoreLine : ignoreLines) {
                    this.logger.trace("Registering ignore rule {0}:{1}", new Object[]{path, ignoreLine});
                    this.ignoredResources.registerRegExpIgnoreRule(path, ignoreLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private <T> T executeCommand(Command<T> command) throws RepositoryException {
        Result result = command.execute();
        return (T)result.get();
    }

    private IFolder createFolder(IProject project, IPath destinationPath) throws CoreException {
        IFolder destinationFolder = project.getFolder(destinationPath);
        if (!destinationFolder.exists()) {
            this.logger.trace("Creating folder {0}", new Object[]{destinationFolder.getFullPath()});
            this.createParents(destinationFolder.getParent());
            destinationFolder.create(true, true, null);
        }
        destinationFolder.setSessionProperty(ResourceUtil.QN_IMPORT_MODIFICATION_TIMESTAMP, (Object)destinationFolder.getModificationStamp());
        this.removeTouchedResource((IResource)destinationFolder);
        return destinationFolder;
    }

    private void createParents(IContainer container) throws CoreException {
        if (container.exists() || container.getType() != 2) {
            return;
        }
        this.createParents(container.getParent());
        this.createFolder(container.getProject(), container.getProjectRelativePath());
    }

    private void removeTouchedResource(IResource resource) {
        IResource current = resource;
        do {
            this.currentResources.remove(current);
        } while ((current = current.getParent()) != null);
    }

    private void createFile(IProject project, IPath path, byte[] node) throws CoreException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        IFile destinationFile = project.getFile(path);
        this.logger.trace("Writing content file at {0}", new Object[]{path});
        if (destinationFile.exists()) {
            destinationFile.setContents((InputStream)new ByteArrayInputStream(node), 2, null);
        } else {
            if (!destinationFile.getParent().exists()) {
                this.createParents(destinationFile.getParent());
            }
            destinationFile.create((InputStream)new ByteArrayInputStream(node), true, null);
        }
        this.removeTouchedResource((IResource)destinationFile);
        destinationFile.setSessionProperty(ResourceUtil.QN_IMPORT_MODIFICATION_TIMESTAMP, (Object)destinationFile.getModificationStamp());
    }
}

