/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.ui.internal.SlingLaunchpadCombo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.wst.server.core.IServer;

public class ExportWizardPage
extends WizardDataTransferPage {
    private SlingLaunchpadCombo repositoryCombo;
    private IResource syncStartPoint;
    boolean hasValidFilter;

    public ExportWizardPage(IResource syncStartPoint) {
        super("Repository selection");
        this.setTitle("Repository selection");
        this.setDescription("Select a repository to export content to");
        this.syncStartPoint = syncStartPoint;
        this.hasValidFilter = false;
    }

    public void handleEvent(Event event) {
        this.determinePageCompletion();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 450;
        container.setLayoutData((Object)gridData);
        new Label(container, 0).setText("Repository: ");
        this.repositoryCombo = new SlingLaunchpadCombo(container, this.syncStartPoint.getProject());
        this.repositoryCombo.getWidget().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportWizardPage.this.determinePageCompletion();
                ExportWizardPage.this.updateWidgetEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportWizardPage.this.determinePageCompletion();
                ExportWizardPage.this.updateWidgetEnablements();
            }
        });
        this.repositoryCombo.refreshRepositoryList((IProgressMonitor)new NullProgressMonitor());
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        this.updateWidgetEnablements();
        this.determinePageCompletion();
    }

    public IServer getServer() {
        return this.repositoryCombo.getServer();
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroup(Composite parent) {
        Label filterLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)filterLabel);
        IFile filterFile = null;
        IPath path = ProjectUtil.findFilterPath((IProject)this.syncStartPoint.getProject());
        if (path != null) {
            filterFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        }
        if (filterFile != null && filterFile.exists()) {
            filterLabel.setText("Will apply export filter from /" + filterFile.getProjectRelativePath() + ".");
            this.hasValidFilter = true;
        }
    }

    protected boolean validateDestinationGroup() {
        String repositoryError = this.repositoryCombo.getErrorMessage(new SlingLaunchpadCombo.ValidationFlag[0]);
        if (repositoryError != null) {
            this.setErrorMessage(repositoryError);
            return false;
        }
        return true;
    }

    protected boolean validateSourceGroup() {
        if (!this.hasValidFilter) {
            this.setErrorMessage("No valid filter found in this project!");
            return false;
        }
        return true;
    }
}

