/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.core.internal.ResourceChangeCommandFactory;
import org.apache.sling.ide.eclipse.ui.WhitelabelSupport;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.internal.ExportWizardPage;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.Result;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.server.core.IServer;

public class ExportWizard
extends Wizard {
    private IResource syncStartPoint;
    private ExportWizardPage exportPage;

    public void init(IWorkbench workbench, IResource syncStartPoint) {
        this.setWindowTitle("Repositoy Export");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(WhitelabelSupport.getWizardBanner());
        this.syncStartPoint = syncStartPoint;
        this.exportPage = new ExportWizardPage(syncStartPoint);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final ResourceChangeCommandFactory factory = new ResourceChangeCommandFactory(Activator.getDefault().getSerializationManager(), Activator.getDefault().getPreferences().getIgnoredFileNamesForSync());
                    final Repository[] selectedServer = new Repository[1];
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                selectedServer[0] = ServerUtil.getConnectedRepository((IServer)ExportWizard.this.exportPage.getServer(), (IProgressMonitor)monitor);
                            }
                            catch (CoreException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    try {
                        ExportWizard.this.syncStartPoint.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                Command command = factory.newCommandForAddedOrUpdated(selectedServer[0], resource);
                                if (command == null) {
                                    return true;
                                }
                                Result result = command.execute();
                                if (!result.isSuccess()) {
                                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed exporting: " + result.toString()));
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new InvocationTargetException(t);
                    }
                }
            });
            return true;
        }
        catch (InterruptedException | RuntimeException e) {
            this.exportPage.setErrorMessage(e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            this.exportPage.setErrorMessage(e.getCause().getMessage());
            return false;
        }
    }
}

