/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.dnd.assistant;

import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.ui.dnd.assistant.StatusLineUtils;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class JcrDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof JcrNode) {
            JcrNode jcrNode = (JcrNode)target;
            IStatus result = jcrNode.validateDrop(operation, transferType);
            if (!result.isOK()) {
                String message = result.getMessage();
                if (message != null && message.trim().length() > 0) {
                    StatusLineUtils.setErrorMessage(2000, message);
                } else {
                    StatusLineUtils.resetErrorMessage();
                }
            } else {
                StatusLineUtils.resetErrorMessage();
            }
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (aTarget == null) {
            return Status.CANCEL_STATUS;
        }
        if (!(aTarget instanceof JcrNode)) {
            StatusLineUtils.setErrorMessage(5000, "Cannot drop on this type of element");
            return Status.CANCEL_STATUS;
        }
        JcrNode node = (JcrNode)aTarget;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            try {
                String message;
                IStatus status = node.handleDrop(aDropTargetEvent.data, aDropTargetEvent.detail);
                if (!status.isOK() && (message = status.getMessage()) != null && message.trim().length() > 0) {
                    StatusLineUtils.setErrorMessage(5000, message);
                }
                return status;
            }
            catch (Exception e) {
                Activator.getDefault().getPluginLogger().error("Error handling drop: " + e, (Throwable)e);
                StatusLineUtils.setErrorMessage(5000, "Could not drop due to: " + e);
                return Status.CANCEL_STATUS;
            }
        }
        if (FileTransfer.getInstance().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            IContainer targetContainer = node.getDropContainer();
            if (targetContainer == null) {
                return Status.CANCEL_STATUS;
            }
            this.getShell().forceActive();
            Object data = FileTransfer.getInstance().nativeToJava(aDropAdapter.getCurrentTransfer());
            new CopyFilesAndFoldersOperation(this.getShell()).copyOrLinkFiles((String[])data, targetContainer, aDropAdapter.getCurrentOperation());
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

