/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.RepositoryException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class NewNodeDialog
extends InputDialog {
    private static String lastChosenNodeType = null;
    private final String parentNodeType;
    private final NodeTypeRegistry ntManager;
    protected String comboSelection;
    private Collection<String> allowedChildren;
    private Combo combo;
    private ContentProposalAdapter proposalAdapter;
    private NodeDefinition[] allChildNodeDefs;

    public NewNodeDialog(Shell parentShell, JcrNode node, NodeTypeRegistry ntManager) throws RepositoryException {
        super(parentShell, "Enter Node Name", "Enter name for new node under:\n path: " + node.getJcrPath(), "", null);
        this.parentNodeType = node.getPrimaryType();
        this.ntManager = ntManager;
        if (ntManager != null) {
            LinkedList<String> ac = new LinkedList<String>(ntManager.getAllowedPrimaryChildNodeTypes(this.parentNodeType));
            NodeType parentNt = ntManager.getNodeType(this.parentNodeType);
            this.allChildNodeDefs = parentNt.getChildNodeDefinitions();
            Collections.sort(ac);
            this.allowedChildren = ac;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Control[] children = composite.getChildren();
        Control errorMessageText = children[children.length - 1];
        GridData errorMessageGridData = new GridData(768);
        errorMessageGridData.heightHint = this.convertHeightInCharsToPixels(2);
        errorMessageText.setLayoutData((Object)errorMessageGridData);
        Label label = new Label(composite, 64);
        label.moveAbove(errorMessageText);
        label.setText("Define node type");
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.combo = new Combo(composite, 4);
        this.combo.moveAbove(errorMessageText);
        if (this.allowedChildren != null) {
            this.combo.setItems(this.allowedChildren.toArray(new String[0]));
        }
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewNodeDialog.this.comboSelection = NewNodeDialog.this.combo.getText();
                NewNodeDialog.this.validateInput();
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewNodeDialog.this.comboSelection = NewNodeDialog.this.combo.getText();
                NewNodeDialog.this.validateInput();
            }
        });
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(this.combo.getItems());
        proposalProvider.setFiltering(true);
        ComboContentAdapter controlContentAdapter = new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Point selection = NewNodeDialog.this.combo.getSelection();
                NewNodeDialog.this.combo.setText(text);
                selection.x += cursorPosition;
                selection.y = selection.x;
                NewNodeDialog.this.combo.setSelection(selection);
            }

            public Rectangle getInsertionBounds(Control control) {
                Rectangle insertionBounds = super.getInsertionBounds(control);
                insertionBounds.x = 0;
                insertionBounds.y = 0;
                return insertionBounds;
            }
        };
        this.proposalAdapter = new ContentProposalAdapter((Control)this.combo, (IControlContentAdapter)controlContentAdapter, (IContentProposalProvider)proposalProvider, null, null);
        if (this.allowedChildren != null && this.allowedChildren.size() == 1) {
            this.combo.setText(this.allowedChildren.iterator().next());
        } else if (this.allowedChildren != null && this.allowedChildren.contains(lastChosenNodeType)) {
            this.combo.setText(lastChosenNodeType);
        }
        return composite;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point size = this.combo.getSize();
        size.x /= 2;
        size.y = 180;
        this.proposalAdapter.setPopupSize(size);
    }

    public String getChosenNodeType() {
        lastChosenNodeType = this.comboSelection;
        return this.comboSelection;
    }

    protected void validateInput() {
        String firstInput = this.getText().getText();
        String secondInput = this.comboSelection;
        try {
            if (secondInput == null || secondInput.length() == 0) {
                this.setErrorMessage("");
            } else if (this.ntManager == null) {
                this.setErrorMessage(null);
            } else if (this.ntManager.isAllowedPrimaryChildNodeType(this.parentNodeType, secondInput)) {
                if (this.allChildNodeDefs == null) {
                    this.setErrorMessage("No child node definitions found for " + this.parentNodeType);
                } else {
                    NodeDefinition aChildNodeDef;
                    boolean success = false;
                    int i = 0;
                    while (i < this.allChildNodeDefs.length) {
                        aChildNodeDef = this.allChildNodeDefs[i];
                        if (aChildNodeDef.getName() != null && aChildNodeDef.getName().length() > 0) {
                            if (firstInput.equals(aChildNodeDef.getName())) {
                                this.setErrorMessage(null);
                                return;
                            }
                        } else {
                            success = true;
                        }
                        ++i;
                    }
                    if (success) {
                        this.setErrorMessage(null);
                        return;
                    }
                    StringBuffer details = new StringBuffer();
                    NodeDefinition[] nodeDefinitionArray = this.allChildNodeDefs;
                    int n = this.allChildNodeDefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        aChildNodeDef = nodeDefinitionArray[n2];
                        if (details.length() != 0) {
                            details.append(", ");
                        }
                        details.append("(name=" + aChildNodeDef.getName() + ", required primary type(s)=");
                        String[] requiredPrimaryTypeNames = aChildNodeDef.getRequiredPrimaryTypeNames();
                        if (requiredPrimaryTypeNames == null) {
                            details.append("null");
                        } else {
                            int j = 0;
                            while (j < requiredPrimaryTypeNames.length) {
                                String rptn = requiredPrimaryTypeNames[j];
                                if (j > 0) {
                                    details.append(",");
                                }
                                details.append(rptn);
                                ++j;
                            }
                        }
                        details.append(")");
                        ++n2;
                    }
                    this.setErrorMessage("No matching child node definition found for " + this.parentNodeType + ". Expected one of: " + details);
                }
            } else {
                this.setErrorMessage("Error: Invalid child node type of " + this.parentNodeType);
            }
        }
        catch (RepositoryException e) {
            this.setErrorMessage("RepositoryException: " + (Object)((Object)e));
        }
    }
}

