/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.support.impl;

import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.support.impl.InternalRequest;
import org.apache.sling.hc.support.impl.InternalResponse;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.hc.support.SlingRequestStatusHealthCheck", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="hc.name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY), @Property(name="hc.mbean.name")})
@Service(value={HealthCheck.class})
public class SlingRequestStatusHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(SlingRequestStatusHealthCheck.class);
    private String[] paths;
    @Property(unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_PATH = "path";
    @Reference
    private SlingRequestProcessor requestProcessor;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.paths = PropertiesUtil.toStringArray((Object)properties.get(PROP_PATH), (String[])new String[0]);
        log.info("Activated, paths={}", Arrays.asList(this.paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        ResourceResolver resolver = null;
        int checked = 0;
        int failed = 0;
        String lastPath = null;
        try {
            resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            String[] arr$ = this.paths;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String p;
                lastPath = p = arr$[i$];
                PathSpec ps = new PathSpec(p, resultLog);
                InternalRequest request = new InternalRequest(ps.path);
                InternalResponse response = new InternalResponse();
                this.requestProcessor.processRequest((HttpServletRequest)request, (HttpServletResponse)response, resolver);
                int status = response.getStatus();
                if (status != ps.status) {
                    ++failed;
                    resultLog.warn("[{}] returns status {}, expected {}", new Object[]{ps.path, status, ps.status});
                } else {
                    resultLog.debug("[{}] returns status {} as expected", new Object[]{ps.path, status});
                }
                ++checked;
            }
        }
        catch (Exception e) {
            resultLog.warn("Exception while executing request [{}]: {}", new Object[]{lastPath, e});
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        if (checked == 0) {
            resultLog.warn("No paths checked, empty paths list?", new Object[0]);
        } else {
            resultLog.debug("{} paths checked, {} failures", new Object[]{checked, failed});
        }
        return new Result((ResultLog)resultLog);
    }

    protected void bindRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        this.requestProcessor = slingRequestProcessor;
    }

    protected void unbindRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        if (this.requestProcessor == slingRequestProcessor) {
            this.requestProcessor = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    static class PathSpec {
        int status;
        String path;

        PathSpec(String configuredPath, FormattingResultLog resultLog) {
            this.path = configuredPath;
            this.status = 200;
            String[] parts = configuredPath.split(":");
            if (parts.length == 2) {
                try {
                    this.status = Integer.valueOf(parts[1].trim());
                    this.path = parts[0].trim();
                }
                catch (NumberFormatException nfe) {
                    resultLog.healthCheckError("NumberFormatException while parsing [{}], invalid status value?", new Object[]{configuredPath});
                }
            }
        }
    }
}

