/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.support.impl;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.hc.support.DefaultLoginsHealthCheck", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="hc.name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY), @Property(name="hc.mbean.name")})
@Service(value={HealthCheck.class})
public class DefaultLoginsHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_LOGINS = "logins";
    private List<String> logins;
    @Reference
    private SlingRepository repository;

    @Activate
    public void activate(ComponentContext ctx) {
        this.logins = Arrays.asList(PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_LOGINS), (String[])new String[0]));
        this.log.info("Activated, logins={}", this.logins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        int checked = 0;
        int failures = 0;
        for (String login : this.logins) {
            String[] parts = login.split(":");
            if (parts.length != 2) {
                resultLog.warn("Expected login in the form username:password, got [{}]", new Object[]{login});
                continue;
            }
            ++checked;
            String username = parts[0].trim();
            String password = parts[1].trim();
            SimpleCredentials creds = new SimpleCredentials(username, password.toCharArray());
            Session s = null;
            try {
                s = this.repository.login((Credentials)creds);
                if (s != null) {
                    ++failures;
                    resultLog.warn("Login as [{}] succeeded, was expecting it to fail", new Object[]{username});
                    continue;
                }
                resultLog.debug("Login as [{}] didn't throw an Exception but returned null Session", new Object[]{username});
            }
            catch (RepositoryException re) {
                resultLog.debug("Login as [{}] failed, as expected", new Object[]{username});
            }
            finally {
                if (s == null) continue;
                s.logout();
            }
        }
        if (checked == 0) {
            resultLog.warn("Did not check any logins, configured logins={}", new Object[]{this.logins});
        } else if (failures != 0) {
            resultLog.warn("Checked {} logins, {} failures", new Object[]{checked, failures});
        } else {
            resultLog.debug("Checked {} logins, all successful", new Object[]{checked, failures});
        }
        return new Result((ResultLog)resultLog);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

