/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.jmx.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.sling.hc.jmx.impl.HealthCheckMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HealthCheckMBeanCreator {
    private static final String JMX_TYPE_NAME = "HealthCheck";
    private static final String JMX_DOMAIN = "org.apache.sling.healthcheck";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ServiceReference, Registration> registeredServices = new HashMap<ServiceReference, Registration>();
    private final Map<String, List<ServiceReference>> sortedRegistrations = new HashMap<String, List<ServiceReference>>();
    private ServiceTracker hcTracker;
    @Reference
    private ExtendedHealthCheckExecutor executor;

    @Activate
    protected void activate(final BundleContext btx) {
        this.hcTracker = new ServiceTracker(btx, HealthCheck.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                return HealthCheckMBeanCreator.this.registerHCMBean(btx, reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
                HealthCheckMBeanCreator.this.unregisterHCMBean(btx, reference);
                HealthCheckMBeanCreator.this.registerHCMBean(btx, reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                HealthCheckMBeanCreator.this.unregisterHCMBean(btx, reference);
            }
        };
        this.hcTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.hcTracker != null) {
            this.hcTracker.close();
            this.hcTracker = null;
        }
    }

    private synchronized Object registerHCMBean(BundleContext bundleContext, ServiceReference reference) {
        Registration reg = this.getRegistration(reference);
        if (reg != null) {
            this.registeredServices.put(reference, reg);
            List<ServiceReference> registered = this.sortedRegistrations.get(reg.name);
            if (registered == null) {
                registered = new ArrayList<ServiceReference>();
                this.sortedRegistrations.put(reg.name, registered);
            }
            registered.add(reference);
            Collections.sort(registered);
            int lastIndex = registered.size() - 1;
            if (registered.get(lastIndex).equals(reference)) {
                if (registered.size() > 1) {
                    ServiceReference prevRef = registered.get(lastIndex - 1);
                    Registration prevReg = this.registeredServices.get(prevRef);
                    prevReg.unregister();
                }
                reg.register(bundleContext);
            }
        }
        return reg;
    }

    private synchronized void unregisterHCMBean(BundleContext bundleContext, ServiceReference ref) {
        Registration reg = this.registeredServices.remove(ref);
        if (reg != null) {
            boolean registerFirst = reg.unregister();
            List<ServiceReference> registered = this.sortedRegistrations.get(reg.name);
            registered.remove(ref);
            if (registered.size() == 0) {
                this.sortedRegistrations.remove(reg.name);
            } else if (registerFirst) {
                ServiceReference newRef = registered.get(0);
                Registration newReg = this.registeredServices.get(newRef);
                newReg.register(bundleContext);
            }
            bundleContext.ungetService(ref);
        }
    }

    private Registration getRegistration(ServiceReference ref) {
        Object nameObj = ref.getProperty("hc.mbean.name");
        if (nameObj != null) {
            HealthCheckMBean mbean = new HealthCheckMBean(ref, this.executor);
            return new Registration(nameObj.toString().replace(',', '.'), mbean);
        }
        return null;
    }

    protected void bindExecutor(ExtendedHealthCheckExecutor extendedHealthCheckExecutor) {
        this.executor = extendedHealthCheckExecutor;
    }

    protected void unbindExecutor(ExtendedHealthCheckExecutor extendedHealthCheckExecutor) {
        if (this.executor == extendedHealthCheckExecutor) {
            this.executor = null;
        }
    }

    private final class Registration {
        private final String name;
        private final HealthCheckMBean mbean;
        private final String objectName;
        private ServiceRegistration registration;

        Registration(String name, HealthCheckMBean mbean) {
            this.name = name;
            this.mbean = mbean;
            this.objectName = String.format("%s:type=%s,name=%s", HealthCheckMBeanCreator.JMX_DOMAIN, HealthCheckMBeanCreator.JMX_TYPE_NAME, name);
        }

        void register(BundleContext btx) {
            HealthCheckMBeanCreator.this.logger.debug("Registering health check mbean {} with name {}", (Object)this.mbean, (Object)this.objectName);
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", this.objectName);
            this.registration = btx.registerService(DynamicMBean.class.getName(), (Object)this.mbean, mbeanProps);
        }

        boolean unregister() {
            if (this.registration != null) {
                HealthCheckMBeanCreator.this.logger.debug("Unregistering health check mbean {} with name {}", (Object)this.mbean, (Object)this.objectName);
                this.registration.unregister();
                this.registration = null;
                return true;
            }
            return false;
        }
    }
}

