/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.jmx.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.osgi.framework.ServiceReference;

public class HealthCheckMBean
implements DynamicMBean {
    private static final String HC_OK_ATTRIBUTE_NAME = "ok";
    private static final String HC_STATUS_ATTRIBUTE_NAME = "status";
    private static final String HC_LOG_ATTRIBUTE_NAME = "log";
    private static final String HC_TIMED_OUT_ATTRIBUTE_NAME = "timedOut";
    private static final String HC_ELAPSED_TIMED_ATTRIBUTE_NAME = "elapsedTime";
    private static final String HC_FINISHED_AT_ATTRIBUTE_NAME = "finishedAt";
    private static CompositeType LOG_ROW_TYPE;
    private static TabularType LOG_TABLE_TYPE;
    private static final String INDEX_COLUMN = "index";
    private static final String LEVEL_COLUMN = "level";
    private static final String MESSAGE_COLUMN = "message";
    private final ServiceReference healthCheckRef;
    private final ExtendedHealthCheckExecutor executor;
    private final MBeanInfo mbeanInfo;
    private final Map<String, Object> defaultAttributes;

    public HealthCheckMBean(ServiceReference ref, ExtendedHealthCheckExecutor executor) {
        this.healthCheckRef = ref;
        this.executor = executor;
        this.mbeanInfo = this.createMBeanInfo(ref);
        this.defaultAttributes = this.createDefaultAttributes(ref);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeList result = this.getAttributes(new String[]{attribute});
        if (result.size() == 0) {
            throw new AttributeNotFoundException(attribute);
        }
        Attribute attr = (Attribute)result.get(0);
        return attr.getValue();
    }

    private TabularData logData(Result er) throws OpenDataException {
        TabularDataSupport result = new TabularDataSupport(LOG_TABLE_TYPE);
        int i = 1;
        for (ResultLog.Entry e : er) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(INDEX_COLUMN, i++);
            data.put(LEVEL_COLUMN, e.getStatus().toString());
            data.put(MESSAGE_COLUMN, e.getMessage());
            result.put(new CompositeDataSupport(LOG_ROW_TYPE, data));
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        if (attributes != null) {
            HealthCheckExecutionResult hcResult = null;
            for (String key : attributes) {
                Object defaultValue = this.defaultAttributes.get(key);
                if (defaultValue != null) {
                    result.add(new Attribute(key, defaultValue));
                    continue;
                }
                if (hcResult == null) {
                    hcResult = this.getHealthCheckResult();
                }
                if (HC_OK_ATTRIBUTE_NAME.equals(key)) {
                    result.add(new Attribute(key, hcResult.getHealthCheckResult().isOk()));
                    continue;
                }
                if (HC_LOG_ATTRIBUTE_NAME.equals(key)) {
                    try {
                        result.add(new Attribute(key, this.logData(hcResult.getHealthCheckResult())));
                    }
                    catch (OpenDataException openDataException) {}
                    continue;
                }
                if (HC_STATUS_ATTRIBUTE_NAME.equals(key)) {
                    result.add(new Attribute(key, hcResult.getHealthCheckResult().getStatus().toString()));
                    continue;
                }
                if (HC_ELAPSED_TIMED_ATTRIBUTE_NAME.equals(key)) {
                    result.add(new Attribute(key, hcResult.getElapsedTimeInMs()));
                    continue;
                }
                if (HC_FINISHED_AT_ATTRIBUTE_NAME.equals(key)) {
                    result.add(new Attribute(key, hcResult.getFinishedAt()));
                    continue;
                }
                if (!HC_TIMED_OUT_ATTRIBUTE_NAME.equals(key)) continue;
                result.add(new Attribute(key, hcResult.hasTimedOut()));
            }
        }
        return result;
    }

    private MBeanInfo createMBeanInfo(ServiceReference serviceReference) {
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        if (serviceReference.getProperty("hc.name") != null) {
            attrs.add(new MBeanAttributeInfo("hc.name", String.class.getName(), "The name of the health check service.", true, false, false));
        }
        if (serviceReference.getProperty("hc.tags") != null) {
            attrs.add(new MBeanAttributeInfo("hc.tags", String.class.getName(), "The tags of the health check service.", true, false, false));
        }
        attrs.add(new MBeanAttributeInfo(HC_OK_ATTRIBUTE_NAME, Boolean.class.getName(), "The health check result", true, false, false));
        attrs.add(new MBeanAttributeInfo(HC_STATUS_ATTRIBUTE_NAME, String.class.getName(), "The health check status", true, false, false));
        attrs.add(new MBeanAttributeInfo(HC_ELAPSED_TIMED_ATTRIBUTE_NAME, Long.class.getName(), "The elapsed time in miliseconds", true, false, false));
        attrs.add(new MBeanAttributeInfo(HC_FINISHED_AT_ATTRIBUTE_NAME, Date.class.getName(), "The date when the execution finished", true, false, false));
        attrs.add(new MBeanAttributeInfo(HC_TIMED_OUT_ATTRIBUTE_NAME, Boolean.class.getName(), "Indicates of the execution timed out", true, false, false));
        attrs.add(new OpenMBeanAttributeInfoSupport(HC_LOG_ATTRIBUTE_NAME, "The health check result log", LOG_TABLE_TYPE, true, false, false));
        String description = serviceReference.getProperty("service.description") != null ? serviceReference.getProperty("service.description").toString() : "Health check";
        return new MBeanInfo(this.getClass().getName(), description, attrs.toArray(new MBeanAttributeInfo[attrs.size()]), null, null, null);
    }

    private Map<String, Object> createDefaultAttributes(ServiceReference serviceReference) {
        HashMap<String, Object> list = new HashMap<String, Object>();
        if (serviceReference.getProperty("hc.name") != null) {
            list.put("hc.name", serviceReference.getProperty("hc.name").toString());
        }
        if (serviceReference.getProperty("hc.tags") != null) {
            Object value = serviceReference.getProperty("hc.tags");
            if (value instanceof String[]) {
                list.put("hc.tags", Arrays.toString((String[])value));
            } else {
                list.put("hc.tags", value.toString());
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support operations."));
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support setting attributes."));
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    public String toString() {
        return "HealthCheckMBean [healthCheck=" + this.healthCheckRef + "]";
    }

    private HealthCheckExecutionResult getHealthCheckResult() {
        return this.executor.execute(this.healthCheckRef);
    }

    static {
        try {
            LOG_ROW_TYPE = new CompositeType("LogLine", "A line in the result log", new String[]{INDEX_COLUMN, LEVEL_COLUMN, MESSAGE_COLUMN}, new String[]{"log line index", "log level", "log message"}, new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING});
            String[] indexes = new String[]{INDEX_COLUMN};
            LOG_TABLE_TYPE = new TabularType("LogTable", "Result log messages", LOG_ROW_TYPE, indexes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

