/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.servlet;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Health Check Verbose Text Serializer", description="Serializes health check results to a verbose text format", metatype=true)
@Service(value={ResultTxtVerboseSerializer.class})
public class ResultTxtVerboseSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ResultTxtVerboseSerializer.class);
    private static final String NEWLINE = "\n";
    public static final int PROP_TOTAL_WIDTH_DEFAULT = 140;
    public static final String PROP_TOTAL_WIDTH = "totalWidth";
    @Property(name="totalWidth", label="Total Width", description="Total width of all columns in verbose txt rendering (in characters)", intValue={140})
    private int totalWidth;
    public static final int PROP_COL_WIDTH_NAME_DEFAULT = 30;
    public static final String PROP_COL_WIDTH_NAME = "colWidthName";
    @Property(name="colWidthName", label="Name Column Width", description="Column width of health check name (in characters)", intValue={30})
    private int colWidthName;
    public static final int PROP_COL_WIDTH_RESULT_DEFAULT = 9;
    public static final String PROP_COL_WIDTH_RESULT = "colWidthResult";
    @Property(name="colWidthResult", label="Result Column Width", description="Column width of health check result (in characters)", intValue={9})
    private int colWidthResult;
    public static final int PROP_COL_WIDTH_TIMING_DEFAULT = 22;
    public static final String PROP_COL_WIDTH_TIMING = "colWidthTiming";
    @Property(name="colWidthTiming", label="Timing Column Width", description="Column width of health check timing (in characters)", intValue={22})
    private int colWidthTiming;
    private int colWidthWithoutLog;
    private int colWidthLog;

    @Activate
    protected final void activate(Map<?, ?> properties) {
        this.totalWidth = PropertiesUtil.toInteger(properties.get(PROP_TOTAL_WIDTH), (int)140);
        this.colWidthName = PropertiesUtil.toInteger(properties.get(PROP_COL_WIDTH_NAME), (int)30);
        this.colWidthResult = PropertiesUtil.toInteger(properties.get(PROP_COL_WIDTH_RESULT), (int)9);
        this.colWidthTiming = PropertiesUtil.toInteger(properties.get(PROP_COL_WIDTH_TIMING), (int)22);
        this.colWidthWithoutLog = this.colWidthName + this.colWidthResult + this.colWidthTiming;
        this.colWidthLog = this.totalWidth - this.colWidthWithoutLog;
    }

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, boolean includeDebug) {
        LOG.debug("Sending verbose txt response... ");
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(StringUtils.repeat((String)"-", (int)this.totalWidth) + NEWLINE);
        resultStr.append(StringUtils.center((String)("Overall Health Result: " + overallResult.getStatus().toString()), (int)this.totalWidth) + NEWLINE);
        resultStr.append(StringUtils.repeat((String)"-", (int)this.totalWidth) + NEWLINE);
        resultStr.append(StringUtils.rightPad((String)"Name", (int)this.colWidthName));
        resultStr.append(StringUtils.rightPad((String)"Result", (int)this.colWidthResult));
        resultStr.append(StringUtils.rightPad((String)"Timing", (int)this.colWidthTiming));
        resultStr.append("Logs\n");
        resultStr.append(StringUtils.repeat((String)"-", (int)this.totalWidth) + NEWLINE);
        SimpleDateFormat dfShort = new SimpleDateFormat("HH:mm:ss.SSS");
        for (HealthCheckExecutionResult healthCheckResult : executionResults) {
            this.appendVerboseTxtForResult(resultStr, healthCheckResult, includeDebug, dfShort);
        }
        resultStr.append(StringUtils.repeat((String)"-", (int)this.totalWidth) + NEWLINE);
        return resultStr.toString();
    }

    private void appendVerboseTxtForResult(StringBuilder resultStr, HealthCheckExecutionResult healthCheckResult, boolean includeDebug, DateFormat dfShort) {
        String wrappedName = WordUtils.wrap((String)healthCheckResult.getHealthCheckMetadata().getName(), (int)this.colWidthName);
        String relevantNameStringForPadding = StringUtils.contains((CharSequence)wrappedName, (CharSequence)NEWLINE) ? StringUtils.substringAfterLast((String)wrappedName, (String)NEWLINE) : wrappedName;
        int paddingSize = this.colWidthName - relevantNameStringForPadding.length();
        resultStr.append(wrappedName + StringUtils.repeat((String)" ", (int)paddingSize));
        resultStr.append(StringUtils.rightPad((String)healthCheckResult.getHealthCheckResult().getStatus().toString(), (int)this.colWidthResult));
        resultStr.append(StringUtils.rightPad((String)("[" + dfShort.format(healthCheckResult.getFinishedAt()) + "|" + FormattingResultLog.msHumanReadable((long)healthCheckResult.getElapsedTimeInMs()) + "]"), (int)this.colWidthTiming));
        boolean isFirst = true;
        for (ResultLog.Entry logEntry : healthCheckResult.getHealthCheckResult()) {
            if (!includeDebug && logEntry.getStatus() == Result.Status.DEBUG) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                resultStr.append(StringUtils.repeat((String)" ", (int)this.colWidthWithoutLog));
            }
            String oneLineMessage = this.getStatusForTxtLog(logEntry) + logEntry.getMessage();
            String messageToPrint = WordUtils.wrap((String)oneLineMessage, (int)this.colWidthLog, (String)(NEWLINE + StringUtils.repeat((String)" ", (int)this.colWidthWithoutLog)), (boolean)true);
            resultStr.append(messageToPrint);
            resultStr.append(NEWLINE);
        }
        if (isFirst) {
            resultStr.append(NEWLINE);
        }
    }

    private String getStatusForTxtLog(ResultLog.Entry logEntry) {
        if (logEntry.getStatus() == Result.Status.OK || logEntry.getStatus() == Result.Status.INFO) {
            return "";
        }
        return logEntry.getStatus().toString() + " ";
    }
}

