/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={ResultJsonSerializer.class})
@Component(metatype=false)
public class ResultJsonSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ResultJsonSerializer.class);
    static final String OVERALL_RESULT_KEY = "OverallResult";

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, String jsonpCallback, boolean includeDebug) {
        LOG.debug("Sending json response... ");
        JsonObjectBuilder result = Json.createObjectBuilder();
        try {
            result.add("overallResult", overallResult.getStatus().toString());
            JsonArrayBuilder resultsJsonArr = Json.createArrayBuilder();
            for (HealthCheckExecutionResult healthCheckResult : executionResults) {
                resultsJsonArr.add((JsonValue)this.getJsonForSimpleResult(healthCheckResult, includeDebug));
            }
            result.add("results", resultsJsonArr);
        }
        catch (JsonException e) {
            LOG.info("Could not serialize health check result: " + (Object)((Object)e), (Throwable)e);
        }
        StringWriter writer = new StringWriter();
        Json.createGenerator((Writer)writer).write((JsonValue)result.build()).close();
        String resultStr = writer.toString();
        if (StringUtils.isNotBlank((CharSequence)jsonpCallback)) {
            resultStr = jsonpCallback + "(" + resultStr + ");";
        }
        return resultStr;
    }

    private JsonObject getJsonForSimpleResult(HealthCheckExecutionResult healthCheckResult, boolean includeDebug) {
        JsonObjectBuilder result = Json.createObjectBuilder();
        result.add("name", healthCheckResult.getHealthCheckMetadata().getName());
        result.add("status", healthCheckResult.getHealthCheckResult().getStatus().toString());
        result.add("timeInMs", healthCheckResult.getElapsedTimeInMs());
        result.add("finishedAt", healthCheckResult.getFinishedAt().toString());
        JsonArrayBuilder tagsArray = Json.createArrayBuilder();
        for (String tag : healthCheckResult.getHealthCheckMetadata().getTags()) {
            tagsArray.add(tag);
        }
        result.add("tags", tagsArray);
        JsonArrayBuilder messagesArr = Json.createArrayBuilder();
        for (ResultLog.Entry entry : healthCheckResult.getHealthCheckResult()) {
            if (!includeDebug && entry.getStatus() == Result.Status.DEBUG) continue;
            JsonObjectBuilder jsonEntry = Json.createObjectBuilder();
            jsonEntry.add("status", entry.getStatus().toString());
            jsonEntry.add("message", entry.getMessage());
            Exception exception = entry.getException();
            if (exception != null) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                jsonEntry.add("exception", stringWriter.toString());
            }
            messagesArr.add(jsonEntry);
        }
        result.add("messages", messagesArr);
        return result.build();
    }
}

