/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.ComponentContext;

@Service(value={ResultHtmlSerializer.class})
@Component(metatype=true, name="Apache Sling Health Check Result HTML Serializer", description="Serializer for health check results in HTML format")
public class ResultHtmlSerializer {
    private static final String CSS_STYLE_DEFAULT = "body { font-size:12px; font-family:arial,verdana,sans-serif;background-color:#FFFDF1; }\nh1 { font-size:20px;}\ntable { font-size:12px; border:#ccc 1px solid; border-radius:3px; }\ntable th { padding:5px; text-align: left; background: #ededed; }\ntable td { padding:5px; border-top: 1px solid #ffffff; border-bottom:1px solid #e0e0e0; border-left: 1px solid #e0e0e0; }\n.statusOK { background-color:#CCFFCC;}\n.statusWARN { background-color:#FFE569;}\n.statusCRITICAL { background-color:#F0975A;}\n.statusHEALTH_CHECK_ERROR { background-color:#F16D4E;}\n.helpText { color:grey; font-size:80%; }\n";
    public static final String PROPERTY_CSS_STYLE = "styleString";
    @Property(name="styleString", label="CSS Style", description="CSS Style - can be configured to change the look and feel of the html result page.", value={"body { font-size:12px; font-family:arial,verdana,sans-serif;background-color:#FFFDF1; }\nh1 { font-size:20px;}\ntable { font-size:12px; border:#ccc 1px solid; border-radius:3px; }\ntable th { padding:5px; text-align: left; background: #ededed; }\ntable td { padding:5px; border-top: 1px solid #ffffff; border-bottom:1px solid #e0e0e0; border-left: 1px solid #e0e0e0; }\n.statusOK { background-color:#CCFFCC;}\n.statusWARN { background-color:#FFE569;}\n.statusCRITICAL { background-color:#F0975A;}\n.statusHEALTH_CHECK_ERROR { background-color:#F16D4E;}\n.helpText { color:grey; font-size:80%; }\n"})
    private String styleString;

    @Activate
    protected final void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.styleString = PropertiesUtil.toString(properties.get(PROPERTY_CSS_STYLE), (String)CSS_STYLE_DEFAULT);
    }

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, String escapedHelpText, boolean includeDebug) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("<html><head><title>System Health</title><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><style>" + this.styleString + "</style></head><body><h1>System Health</h1>");
        writer.println("<p><span class=\"" + this.getClassForStatus(overallResult.getStatus()) + "\"><strong>Overall Result: " + overallResult.getStatus() + "</strong></span></p>");
        SimpleDateFormat dfShort = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat dfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        writer.println("<table id=\"healthCheckResults\" cellspacing=\"0\">");
        writer.println("<thead><tr><th>Health Check <span style='color:gray'>(tags)</span></th><th>Status</th><th>Log</th><th>Finished At</th><th>Time</th></tr></thead>");
        for (HealthCheckExecutionResult executionResult : executionResults) {
            Result result = executionResult.getHealthCheckResult();
            List tags = executionResult.getHealthCheckMetadata().getTags();
            boolean hasTags = tags != null && tags.size() > 0 && StringUtils.isNotBlank((CharSequence)((CharSequence)tags.get(0)));
            writer.print("<tr class=\"" + this.getClassForStatus(result.getStatus()) + "\">");
            writer.print("<td><p title=\"" + StringEscapeUtils.escapeHtml4((String)executionResult.getHealthCheckMetadata().getName()) + "\">" + StringEscapeUtils.escapeHtml4((String)executionResult.getHealthCheckMetadata().getTitle()) + "");
            if (hasTags) {
                writer.println("<br/><span style='color:gray'>" + StringEscapeUtils.escapeHtml4((String)StringUtils.join((Iterable)tags, (String)", ")) + "</span>");
            }
            writer.println("</p></td>");
            writer.println("<td style='font-weight:bold;'>" + StringEscapeUtils.escapeHtml4((String)result.getStatus().toString()) + "</td>");
            writer.println("<td>");
            boolean isFirst = true;
            boolean isSingleResult = this.isSingleResult(result);
            for (ResultLog.Entry entry : result) {
                if (!includeDebug && entry.getStatus() == Result.Status.DEBUG) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.println("<br/>\n");
                }
                boolean showStatus = !isSingleResult && entry.getStatus() != Result.Status.DEBUG && entry.getStatus() != Result.Status.INFO;
                String message = StringEscapeUtils.escapeHtml4((String)entry.getMessage());
                if (entry.getStatus() == Result.Status.DEBUG) {
                    message = "<span style='color:gray'/>" + message + "</span>";
                }
                writer.println((showStatus ? StringEscapeUtils.escapeHtml4((String)entry.getStatus().toString()) + " " : "") + message);
                Exception exception = entry.getException();
                if (exception == null) continue;
                writer.println("<span style='width:20px'/>" + StringEscapeUtils.escapeHtml4((String)exception.toString()));
                writer.println("<!--");
                exception.printStackTrace(writer);
                writer.println("-->");
            }
            writer.println("</td>");
            Date finishedAt = executionResult.getFinishedAt();
            writer.println("<td>" + (this.isToday(finishedAt) ? dfShort.format(finishedAt) : dfLong.format(finishedAt)) + "</td>");
            writer.println("<td>" + FormattingResultLog.msHumanReadable((long)executionResult.getElapsedTimeInMs()) + "</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
        writer.println("<div class='helpText'>");
        writer.println(escapedHelpText);
        writer.println("</div>");
        writer.println("</body></html>");
        return stringWriter.toString();
    }

    private String getClassForStatus(Result.Status status) {
        return "status" + status.name();
    }

    private boolean isSingleResult(Result result) {
        int count = 0;
        for (ResultLog.Entry entry : result) {
            if (++count <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean isToday(Date date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date);
        boolean isToday = cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        return isToday;
    }
}

