/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.executor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.core.impl.executor.ExecutionResult;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckResultCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<Result.Status> NOT_OK_STATUS_VALUES = Arrays.asList(Result.Status.WARN, Result.Status.CRITICAL, Result.Status.HEALTH_CHECK_ERROR);
    private final Map<Long, HealthCheckExecutionResult> cache = new ConcurrentHashMap<Long, HealthCheckExecutionResult>();
    private final Map<Result.Status, Map<Long, HealthCheckExecutionResult>> cacheOfNotOkResults = new ConcurrentHashMap<Result.Status, Map<Long, HealthCheckExecutionResult>>(){
        {
            for (Result.Status status : NOT_OK_STATUS_VALUES) {
                this.put(status, new ConcurrentHashMap());
            }
        }
    };

    public void updateWith(HealthCheckExecutionResult result) {
        ExecutionResult executionResult = (ExecutionResult)result;
        this.cache.put(executionResult.getServiceId(), result);
        Result.Status status = executionResult.getHealthCheckResult().getStatus();
        if (status.ordinal() >= Result.Status.WARN.ordinal()) {
            this.logger.debug("Caching {} result for HC {}", (Object)status, (Object)executionResult.getServiceId());
            this.cacheOfNotOkResults.get(status).put(executionResult.getServiceId(), result);
        }
    }

    public void useValidCacheResults(List<HealthCheckMetadata> metadatas, Collection<HealthCheckExecutionResult> results, long resultCacheTtlInMs) {
        TreeSet<HealthCheckExecutionResult> cachedResults = new TreeSet<HealthCheckExecutionResult>();
        Iterator<HealthCheckMetadata> checksIt = metadatas.iterator();
        while (checksIt.hasNext()) {
            HealthCheckMetadata md = checksIt.next();
            HealthCheckExecutionResult result = this.getValidCacheResult(md, resultCacheTtlInMs);
            if (result == null) continue;
            cachedResults.add(result);
            checksIt.remove();
        }
        this.logger.debug("Adding {} results from cache", (Object)cachedResults.size());
        results.addAll(cachedResults);
    }

    public HealthCheckExecutionResult getValidCacheResult(HealthCheckMetadata metadata, long resultCacheTtlInMs) {
        return this.get(metadata, resultCacheTtlInMs);
    }

    private HealthCheckExecutionResult get(HealthCheckMetadata metadata, long globalResultCacheTtlInMs) {
        Long key = metadata.getServiceId();
        HealthCheckExecutionResult cachedResult = this.cache.get(key);
        if (cachedResult != null) {
            Date now;
            Date validUntil;
            Date finishedAt = cachedResult.getFinishedAt();
            if (finishedAt == null) {
                this.cache.remove(key);
                return null;
            }
            long effectiveTtl = this.getEffectiveTtl(metadata, globalResultCacheTtlInMs);
            long validUntilLong = finishedAt.getTime() + effectiveTtl;
            if (validUntilLong < 0L) {
                validUntilLong = Long.MAX_VALUE;
            }
            if ((validUntil = new Date(validUntilLong)).after(now = new Date())) {
                this.logger.debug("Cache hit: validUntil={} cachedResult={}", (Object)validUntil, (Object)cachedResult);
                return cachedResult;
            }
            this.logger.debug("Outdated result: validUntil={} cachedResult={}", (Object)validUntil, (Object)cachedResult);
        }
        return null;
    }

    private long getEffectiveTtl(HealthCheckMetadata metadata, long globalTtl) {
        Long hcTtl = metadata.getResultCacheTtlInMs();
        long ttl = hcTtl != null && hcTtl > 0L ? hcTtl : globalTtl;
        return ttl;
    }

    public HealthCheckExecutionResult createExecutionResultWithStickyResults(HealthCheckExecutionResult origResult) {
        HealthCheckExecutionResult result = origResult;
        HealthCheckMetadata healthCheckMetadata = origResult.getHealthCheckMetadata();
        Long warningsStickForMinutes = healthCheckMetadata.getWarningsStickForMinutes();
        if (warningsStickForMinutes != null) {
            this.logger.debug("Taking into account sticky results (up to {} min old) for health check ", (Object)warningsStickForMinutes, (Object)healthCheckMetadata.getName());
            ArrayList<HealthCheckExecutionResult> nonOkResultsFromPast = new ArrayList<HealthCheckExecutionResult>();
            long cutOffTime = System.currentTimeMillis() - warningsStickForMinutes * 60L * 1000L;
            for (Result.Status status : NOT_OK_STATUS_VALUES) {
                long hcServiceId = ((ExecutionResult)origResult).getServiceId();
                HealthCheckExecutionResult nonOkResultFromPast = this.cacheOfNotOkResults.get(status).get(hcServiceId);
                if (nonOkResultFromPast == null) {
                    this.logger.debug("no sticky result in cache for HC {}", (Object)hcServiceId);
                    continue;
                }
                if (nonOkResultFromPast == origResult) {
                    this.logger.debug("result already in cache: {} for HC {}, not adding sticky result", (Object)origResult, (Object)hcServiceId);
                    continue;
                }
                long pastHcTime = nonOkResultFromPast.getFinishedAt().getTime();
                this.logger.debug("Time of old {} result: {}", (Object)status, (Object)pastHcTime);
                this.logger.debug("Cut off time: {}", (Object)cutOffTime);
                if (pastHcTime <= cutOffTime) continue;
                this.logger.debug("Found sticky result: {}", (Object)nonOkResultFromPast);
                nonOkResultsFromPast.add(nonOkResultFromPast);
            }
            if (!nonOkResultsFromPast.isEmpty()) {
                ResultLog resultLog = new ResultLog();
                resultLog.add(new ResultLog.Entry(Result.Status.INFO, "*** Current Result ***"));
                for (ResultLog.Entry entry : origResult.getHealthCheckResult()) {
                    resultLog.add(entry);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                for (HealthCheckExecutionResult nonOkResultFromPast : nonOkResultsFromPast) {
                    Result.Status status = nonOkResultFromPast.getHealthCheckResult().getStatus();
                    resultLog.add(new ResultLog.Entry(Result.Status.WARN, "*** Sticky Result " + status + " from " + simpleDateFormat.format(nonOkResultFromPast.getFinishedAt()) + " ***"));
                    for (ResultLog.Entry entry : nonOkResultFromPast.getHealthCheckResult()) {
                        resultLog.add(entry);
                    }
                }
                result = new ExecutionResult(healthCheckMetadata, new Result(resultLog), origResult.getElapsedTimeInMs());
            }
        }
        return result;
    }

    public void clear() {
        this.cache.clear();
        for (Result.Status status : NOT_OK_STATUS_VALUES) {
            this.cacheOfNotOkResults.get(status).clear();
        }
    }

    public void removeCachedResult(Long serviceId) {
        this.cache.remove(serviceId);
        for (Result.Status status : NOT_OK_STATUS_VALUES) {
            this.cacheOfNotOkResults.get(status).remove(serviceId);
        }
    }

    public String toString() {
        return "[HealthCheckResultCache size=" + this.cache.size() + "]";
    }
}

