/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl;

import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Sling Scriptable Health Check", description="Uses scripted expressions to verify multiple JMX attributes or other values.")
@Properties(value={@Property(name="hc.name", label="Name", description="Name of this health check."), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY, label="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check."), @Property(name="hc.mbean.name", label="MBean Name", description="Name of the MBean to create for this health check. If empty, no MBean is registered.")})
@Service(value={HealthCheck.class})
public class ScriptableHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String expression;
    private String languageExtension;
    private static final String DEFAULT_LANGUAGE_EXTENSION = "ecma";
    @Property(label="Expression", description="The value of this expression must be \"true\" for this check to be successful.")
    public static final String PROP_EXPRESSION = "expression";
    @Property(value={"ecma"}, label="Language Extension", description="File extension of the language to use to evaluate the expression, for example \"ecma\" or \"groovy\", asssuming the corresponding script engine is available. By default \"ecma\" is used.")
    public static final String PROP_LANGUAGE_EXTENSION = "language.extension";
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=BindingsValuesProvider.class, target="(context=healthcheck)")
    private final Set<BindingsValuesProvider> bindingsValuesProviders = new HashSet<BindingsValuesProvider>();

    @Activate
    protected void activate(ComponentContext ctx) {
        this.expression = PropertiesUtil.toString(ctx.getProperties().get(PROP_EXPRESSION), (String)"");
        this.languageExtension = PropertiesUtil.toString(ctx.getProperties().get(PROP_LANGUAGE_EXTENSION), (String)DEFAULT_LANGUAGE_EXTENSION);
        this.log.debug("Activated scriptable health check name={}, languageExtension={}, expression={}", new Object[]{ctx.getProperties().get("hc.name"), this.languageExtension, this.expression});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog;
        block9: {
            resultLog = new FormattingResultLog();
            resultLog.debug("Checking expression [{}], language extension=[{}]", new Object[]{this.expression, this.languageExtension});
            try {
                ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(this.languageExtension);
                if (engine == null) {
                    resultLog.healthCheckError("No ScriptEngine available for extension {}", new Object[]{this.languageExtension});
                    break block9;
                }
                Bindings b = engine.createBindings();
                b.put(FormattingResultLog.class.getName(), (Object)resultLog);
                Set<BindingsValuesProvider> set = this.bindingsValuesProviders;
                synchronized (set) {
                    for (BindingsValuesProvider bvp : this.bindingsValuesProviders) {
                        this.log.debug("Adding Bindings provided by {}", (Object)bvp);
                        bvp.addBindings(b);
                    }
                }
                this.log.debug("All Bindings added: {}", b.keySet());
                Object value = engine.eval(this.expression, b);
                if (value != null && "true".equals(value.toString().toLowerCase())) {
                    resultLog.debug("Expression [{}] evaluates to true as expected", new Object[]{this.expression});
                } else {
                    resultLog.warn("Expression [{}] does not evaluate to true as expected, value=[{}]", new Object[]{this.expression, value});
                }
            }
            catch (Exception e) {
                resultLog.healthCheckError("Exception while evaluating expression [{}] with language extension [{}]: {}", new Object[]{this.expression, this.languageExtension, e});
            }
        }
        return new Result((ResultLog)resultLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindBindingsValuesProvider(BindingsValuesProvider bvp) {
        Set<BindingsValuesProvider> set = this.bindingsValuesProviders;
        synchronized (set) {
            this.bindingsValuesProviders.add(bvp);
        }
        this.log.debug("{} registered: {}", (Object)bvp, this.bindingsValuesProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindBindingsValuesProvider(BindingsValuesProvider bvp) {
        Set<BindingsValuesProvider> set = this.bindingsValuesProviders;
        synchronized (set) {
            this.bindingsValuesProviders.remove(bvp);
        }
        this.log.debug("{} unregistered: {}", (Object)bvp, this.bindingsValuesProviders);
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }
}

