/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.script.Bindings;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="context", value={"healthcheck"})
public class JmxScriptBindingsProvider
implements BindingsValuesProvider {
    private MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String JMX_BINDING_NAME = "jmx";

    public void addBindings(Bindings b) {
        String logBindingName = FormattingResultLog.class.getName();
        Object resultLog = b.get(logBindingName);
        if (resultLog == null) {
            this.log.debug("No {} found in Bindings, cannot activate {} binding", (Object)logBindingName, (Object)JMX_BINDING_NAME);
            return;
        }
        try {
            b.put(JMX_BINDING_NAME, (Object)new AttributeBinding(this.jmxServer, (FormattingResultLog)resultLog));
        }
        catch (Exception e) {
            this.log.error("Exception while activating jmx", (Throwable)e);
        }
    }

    public static class AttributeBinding {
        private final MBeanServer jmxServer;
        private final FormattingResultLog resultLog;

        AttributeBinding(MBeanServer s, FormattingResultLog r) {
            this.jmxServer = s;
            this.resultLog = r;
        }

        public Object attribute(String objectNameString, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
            ObjectName name = new ObjectName(objectNameString);
            if (this.jmxServer.queryNames(name, null).size() == 0) {
                String msg = "JMX object name not found: [" + objectNameString + "]";
                this.resultLog.warn(msg, new Object[0]);
                throw new IllegalStateException(msg);
            }
            this.resultLog.debug("Got JMX Object [{}]", new Object[]{name});
            Object value = this.jmxServer.getAttribute(name, attributeName);
            this.resultLog.debug("JMX Object [{}] Attribute [{}] = [{}]", new Object[]{name, attributeName, value});
            return value;
        }
    }
}

