/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.hc.util.SimpleConstraintChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Sling JMX Attribute Health Check", description="Checks the value of a single JMX attribute.")
@Properties(value={@Property(name="hc.name", label="Name", description="Name of this health check."), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY, label="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check."), @Property(name="hc.mbean.name", label="MBean Name", description="Name of the MBean to create for this health check. If empty, no MBean is registered.")})
@Service(value={HealthCheck.class})
public class JmxAttributeHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mbeanName;
    private String attributeName;
    private String constraint;
    @Property(label="Check MBean Name", description="The name of the MBean to check by this health check.")
    public static final String PROP_OBJECT_NAME = "mbean.name";
    @Property(label="Check Attribute Name", description="The name of the MBean attribute to check by this health check.")
    public static final String PROP_ATTRIBUTE_NAME = "attribute.name";
    @Property(label="Check Attribute Constraint", description="Constraint on the MBean attribute value.")
    public static final String PROP_CONSTRAINT = "attribute.value.constraint";

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.mbeanName = PropertiesUtil.toString((Object)properties.get(PROP_OBJECT_NAME), (String)"");
        this.attributeName = PropertiesUtil.toString((Object)properties.get(PROP_ATTRIBUTE_NAME), (String)"");
        this.constraint = PropertiesUtil.toString((Object)properties.get(PROP_CONSTRAINT), (String)"");
        this.log.debug("Activated with HealthCheck name={}, objectName={}, attribute={}, constraint={}", new Object[]{properties.get("hc.name"), this.mbeanName, this.attributeName, this.constraint});
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        resultLog.debug("Checking {} / {} with constraint {}", new Object[]{this.mbeanName, this.attributeName, this.constraint});
        try {
            MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(this.mbeanName);
            if (jmxServer.queryNames(objectName, null).size() == 0) {
                resultLog.warn("MBean not found: {}", new Object[]{objectName});
            } else {
                Object value = jmxServer.getAttribute(objectName, this.attributeName);
                resultLog.debug("{} {} returns {}", new Object[]{this.mbeanName, this.attributeName, value});
                new SimpleConstraintChecker().check(value, this.constraint, (ResultLog)resultLog);
            }
        }
        catch (Exception e) {
            this.log.warn("JMX attribute {}/{} check failed: {}", new Object[]{this.mbeanName, this.attributeName, e});
            resultLog.healthCheckError("JMX attribute check failed: {}", new Object[]{e});
        }
        return new Result((ResultLog)resultLog);
    }
}

