/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.hc.api.execution.HealthCheckSelector;
import org.apache.sling.hc.core.impl.CompositeResult;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.hc.util.HealthCheckFilter;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Sling Composite Health Check", description="Executes a set of health checks, selected by tags.")
@Properties(value={@Property(name="hc.name", label="Name", description="Name of this health check."), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY, label="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check."), @Property(name="hc.mbean.name", label="MBean Name", description="Name of the MBean to create for this health check. If empty, no MBean is registered.")})
@Service(value={HealthCheck.class})
public class CompositeHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEFAULT_COMBINE_TAGS_WITH_OR = false;
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Filter Tags", description="Tags used to select which health checks the composite health check executes.")
    static final String PROP_FILTER_TAGS = "filter.tags";
    private String[] filterTags;
    @Property(boolValue={false}, label="Combine Tags With Or", description="Tags used to select which health checks the composite health check executes.")
    static final String PROP_COMBINE_TAGS_WITH_OR = "filter.combineTagsWithOr";
    private boolean combineTagsWithOr;
    @Reference
    private HealthCheckExecutor healthCheckExecutor;
    private BundleContext bundleContext;
    private HealthCheckFilter healthCheckFilter;
    private volatile ComponentContext componentContext;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.componentContext = ctx;
        this.healthCheckFilter = new HealthCheckFilter(this.bundleContext);
        Dictionary properties = ctx.getProperties();
        this.filterTags = PropertiesUtil.toStringArray(properties.get(PROP_FILTER_TAGS), (String[])new String[0]);
        this.combineTagsWithOr = PropertiesUtil.toBoolean(properties.get(PROP_COMBINE_TAGS_WITH_OR), (boolean)false);
        this.log.debug("Activated, will select HealthCheck having tags {} {}", Arrays.asList(this.filterTags), (Object)(this.combineTagsWithOr ? "using OR" : "using AND"));
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext = null;
        this.healthCheckFilter = null;
        this.componentContext = null;
    }

    public Result execute() {
        Result result;
        ComponentContext localCtx = this.componentContext;
        ServiceReference referenceToThis = localCtx == null ? null : localCtx.getServiceReference();
        Result result2 = result = referenceToThis == null ? null : this.checkForRecursion(referenceToThis, new HashSet<String>());
        if (result != null) {
            return result;
        }
        FormattingResultLog resultLog = new FormattingResultLog();
        HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
        options.setCombineTagsWithOr(this.combineTagsWithOr);
        List executionResults = this.healthCheckExecutor.execute(HealthCheckSelector.tags((String[])this.filterTags), options);
        resultLog.debug("Executing {} HealthChecks selected by tags {}", new Object[]{executionResults.size(), Arrays.asList(this.filterTags)});
        result = new CompositeResult((ResultLog)resultLog, executionResults);
        return result;
    }

    Result checkForRecursion(ServiceReference hcReference, Set<String> alreadyBannedTags) {
        ServiceReference[] hcRefsOfCompositeCheck;
        HealthCheckMetadata thisCheckMetadata = new HealthCheckMetadata(hcReference);
        HashSet<String> bannedTagsForThisCompositeCheck = new HashSet<String>();
        bannedTagsForThisCompositeCheck.addAll(alreadyBannedTags);
        bannedTagsForThisCompositeCheck.addAll(thisCheckMetadata.getTags());
        String[] tagsForIncludedChecksArr = PropertiesUtil.toStringArray((Object)hcReference.getProperty(PROP_FILTER_TAGS), (String[])new String[0]);
        HashSet<String> tagsForIncludedChecks = new HashSet<String>(Arrays.asList(tagsForIncludedChecksArr));
        this.log.debug("HC {} has banned tags {}", (Object)thisCheckMetadata.getName(), bannedTagsForThisCompositeCheck);
        this.log.debug("tagsForIncludedChecks {}", tagsForIncludedChecks);
        HashSet<String> intersection = new HashSet<String>();
        intersection.addAll(bannedTagsForThisCompositeCheck);
        intersection.retainAll(tagsForIncludedChecks);
        if (!intersection.isEmpty()) {
            return new Result(Result.Status.HEALTH_CHECK_ERROR, "INVALID CONFIGURATION: Cycle detected in composite health check hierarchy. Health check '" + thisCheckMetadata.getName() + "' (" + hcReference.getProperty("service.id") + ") must not have tag(s) " + intersection + " as a composite check in the hierarchy is itself already tagged alike (tags assigned to composite checks: " + bannedTagsForThisCompositeCheck + ")");
        }
        for (ServiceReference hcRefOfCompositeCheck : hcRefsOfCompositeCheck = this.healthCheckFilter.getHealthCheckServiceReferences(HealthCheckSelector.tags((String[])tagsForIncludedChecksArr), this.combineTagsWithOr)) {
            if (!CompositeHealthCheck.class.getName().equals(hcRefOfCompositeCheck.getProperty("component.name"))) continue;
            this.log.debug("Checking sub composite HC {}, {}", (Object)hcRefOfCompositeCheck, hcRefOfCompositeCheck.getProperty("component.name"));
            Result result = this.checkForRecursion(hcRefOfCompositeCheck, bannedTagsForThisCompositeCheck);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    void setHealthCheckFilter(HealthCheckFilter healthCheckFilter) {
        this.healthCheckFilter = healthCheckFilter;
    }

    void setFilterTags(String[] filterTags) {
        this.filterTags = filterTags;
    }

    void setCombineTagsWithOr(boolean combineTagsWithOr) {
        this.combineTagsWithOr = combineTagsWithOr;
    }

    void setHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    void setComponentContext(ComponentContext ctx) {
        this.componentContext = ctx;
    }

    protected void bindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    protected void unbindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        if (this.healthCheckExecutor == healthCheckExecutor) {
            this.healthCheckExecutor = null;
        }
    }
}

