/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.execution.HealthCheckSelector;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class HealthCheckFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    public static final String OMIT_PREFIX = "-";
    private final Set<ServiceReference> usedReferences = new HashSet<ServiceReference>();

    public HealthCheckFilter(BundleContext bc) {
        this.bundleContext = bc;
    }

    public List<HealthCheck> getHealthChecks(HealthCheckSelector selector) {
        ServiceReference[] refs = this.getHealthCheckServiceReferences(selector);
        ArrayList<HealthCheck> result = new ArrayList<HealthCheck>();
        if (refs != null) {
            List<ServiceReference> sortedRefs = Arrays.asList(refs);
            Collections.sort(sortedRefs);
            for (ServiceReference ref : sortedRefs) {
                HealthCheck hc = (HealthCheck)this.bundleContext.getService(ref);
                this.log.debug("Selected HealthCheck service {}", (Object)hc);
                if (hc == null) continue;
                this.usedReferences.add(ref);
                result.add(hc);
            }
        }
        return result;
    }

    public ServiceReference[] getHealthCheckServiceReferences(HealthCheckSelector selector) {
        return this.getHealthCheckServiceReferences(selector, false);
    }

    public ServiceReference[] getHealthCheckServiceReferences(HealthCheckSelector selector, boolean combineTagsWithOr) {
        CharSequence filterBuilder = selector != null ? this.getServiceFilter(selector, combineTagsWithOr) : this.getServiceFilter(HealthCheckSelector.empty(), combineTagsWithOr);
        this.log.debug("OSGi service filter in getHealthCheckServiceReferences(): {}", (Object)filterBuilder);
        try {
            String filterString = filterBuilder.length() == 0 ? null : filterBuilder.toString();
            this.bundleContext.createFilter(filterString);
            ServiceReference[] refs = this.bundleContext.getServiceReferences(HealthCheck.class.getName(), filterString);
            if (refs == null) {
                this.log.debug("Found no HealthCheck services with filter [{}]", (Object)filterString);
                return new ServiceReference[0];
            }
            this.log.debug("Found {} HealthCheck services with filter [{}]", (Object)refs.length, (Object)filterString);
            return refs;
        }
        catch (InvalidSyntaxException ise) {
            this.log.error("Invalid OSGi filter syntax in '" + filterBuilder + "'", (Throwable)ise);
            return new ServiceReference[0];
        }
    }

    @Deprecated
    public List<HealthCheck> getTaggedHealthChecks(String ... tags) {
        HealthCheckSelector selector = HealthCheckSelector.tags(tags);
        return this.getHealthChecks(selector);
    }

    @Deprecated
    public ServiceReference[] getTaggedHealthCheckServiceReferences(String ... tags) {
        return this.getHealthCheckServiceReferences(HealthCheckSelector.tags(tags), false);
    }

    @Deprecated
    public ServiceReference[] getTaggedHealthCheckServiceReferences(boolean combineWithOr, String ... tags) {
        HealthCheckSelector selector = HealthCheckSelector.tags(tags);
        return this.getHealthCheckServiceReferences(selector, combineWithOr);
    }

    public void dispose() {
        for (ServiceReference ref : this.usedReferences) {
            this.bundleContext.ungetService(ref);
        }
        this.usedReferences.clear();
    }

    CharSequence getServiceFilter(HealthCheckSelector selector, boolean combineTagsWithOr) {
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append("(&(objectClass=").append(HealthCheck.class.getName()).append(")");
        int prefixLen = OMIT_PREFIX.length();
        StringBuilder filterBuilderForOrOperator = new StringBuilder();
        StringBuilder tagsBuilder = new StringBuilder();
        int tagsAndClauses = 0;
        if (selector.tags() != null) {
            for (String tag : selector.tags()) {
                if ((tag = tag.trim()).length() == 0) continue;
                if (tag.startsWith(OMIT_PREFIX)) {
                    filterBuilder.append("(!(").append("hc.tags").append("=").append(tag.substring(prefixLen)).append("))");
                    continue;
                }
                if (combineTagsWithOr) {
                    filterBuilderForOrOperator.append("(").append("hc.tags").append("=").append(tag).append(")");
                    continue;
                }
                tagsBuilder.append("(").append("hc.tags").append("=").append(tag).append(")");
                ++tagsAndClauses;
            }
        }
        boolean addedNameToOrBuilder = false;
        if (selector.names() != null) {
            for (String name : selector.names()) {
                if ((name = name.trim()).length() == 0) continue;
                if (name.startsWith(OMIT_PREFIX)) {
                    filterBuilder.append("(!(").append("hc.name").append("=").append(name.substring(prefixLen)).append("))");
                    continue;
                }
                filterBuilderForOrOperator.append("(").append("hc.name").append("=").append(name).append(")");
                addedNameToOrBuilder = true;
            }
        }
        if (addedNameToOrBuilder) {
            if (tagsAndClauses > 1) {
                filterBuilderForOrOperator.append("(&").append((CharSequence)tagsBuilder).append(")");
            } else {
                filterBuilderForOrOperator.append((CharSequence)tagsBuilder);
            }
        } else {
            filterBuilder.append((CharSequence)tagsBuilder);
        }
        if (filterBuilderForOrOperator.length() > 0) {
            filterBuilder.append("(|").append((CharSequence)filterBuilderForOrOperator).append(")");
        }
        filterBuilder.append(")");
        return filterBuilder;
    }
}

