/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.helpers.MessageFormatter;

@ProviderType
public class FormattingResultLog
extends ResultLog {
    private ResultLog.Entry createEntry(Result.Status status, String format, Object ... args) {
        return new ResultLog.Entry(status, MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void debug(String format, Object ... args) {
        this.add(this.createEntry(Result.Status.DEBUG, format, args));
    }

    public void info(String format, Object ... args) {
        this.add(this.createEntry(Result.Status.INFO, format, args));
    }

    public void warn(String format, Object ... args) {
        this.add(this.createEntry(Result.Status.WARN, format, args));
    }

    public void critical(String format, Object ... args) {
        this.add(this.createEntry(Result.Status.CRITICAL, format, args));
    }

    public void healthCheckError(String format, Object ... args) {
        this.add(this.createEntry(Result.Status.HEALTH_CHECK_ERROR, format, args));
    }

    public static String msHumanReadable(long millis) {
        double number;
        double currentDivisor;
        String[] units = new String[]{"ms", "sec", "min", "h", "days"};
        double[] divisors = new double[]{1000.0, 60.0, 60.0, 24.0};
        int magnitude = 0;
        for (number = (double)millis; !(number < (currentDivisor = divisors[Math.min(magnitude, divisors.length - 1)])); number /= currentDivisor) {
            if (++magnitude < units.length - 1) continue;
        }
        NumberFormat format = NumberFormat.getNumberInstance(Locale.UK);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(1);
        String result = format.format(number) + units[magnitude];
        return result;
    }
}

