/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.cache;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.apache.sling.graphql.api.cache.GraphQLCacheProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Config.class)
public class SimpleGraphQLCacheProvider
implements GraphQLCacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleGraphQLCacheProvider.class);
    @Reference
    private MetricsService metricsService;
    @Reference(target="(name=sling)")
    private MetricRegistry metricRegistry;
    private InMemoryLRUCache persistedQueriesCache;
    private Lock readLock;
    private Lock writeLock;
    private Counter evictions;
    private static final String METRIC_NS = SimpleGraphQLCacheProvider.class.getName();
    private static final String GAUGE_CACHE_SIZE = METRIC_NS + ".cacheSize";
    private static final String GAUGE_ELEMENTS = METRIC_NS + ".elements";
    private static final String GAUGE_MAX_MEMORY = METRIC_NS + ".maxMemory";
    private static final String GAUGE_CURRENT_MEMORY = METRIC_NS + ".currentMemory";
    private static final String COUNTER_EVICTIONS = METRIC_NS + ".evictions";
    private static final Set<String> MANUALLY_REGISTERED_METRICS = new HashSet<String>(Arrays.asList(GAUGE_CACHE_SIZE, GAUGE_ELEMENTS, GAUGE_MAX_MEMORY, GAUGE_CURRENT_MEMORY));

    @Activate
    private void activate(Config config, BundleContext bundleContext) {
        long maxMemory;
        int capacity;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        if (config.cacheSize() < 0) {
            capacity = 0;
            LOGGER.debug("Cache capacity set to {}. Defaulting to 0.", (Object)config.cacheSize());
        } else {
            capacity = config.cacheSize();
        }
        if (config.maxMemory() < 0L) {
            maxMemory = 0L;
            LOGGER.debug("Cache max memory set to {}. Defaulting to 0.", (Object)config.maxMemory());
        } else {
            maxMemory = config.maxMemory();
        }
        this.persistedQueriesCache = new InMemoryLRUCache(capacity, maxMemory);
        LOGGER.debug("In-memory cache initialized: capacity={}, maxMemory={}.", (Object)capacity, (Object)maxMemory);
        this.metricRegistry.register(GAUGE_CACHE_SIZE, (Metric)((Gauge)() -> capacity));
        this.metricRegistry.register(GAUGE_MAX_MEMORY, (Metric)((Gauge)() -> maxMemory));
        this.metricRegistry.register(GAUGE_CURRENT_MEMORY, (Metric)((Gauge)() -> this.persistedQueriesCache.currentSizeInBytes));
        this.metricRegistry.register(GAUGE_ELEMENTS, (Metric)((Gauge)() -> this.persistedQueriesCache.size()));
        this.evictions = this.metricsService.counter(COUNTER_EVICTIONS);
    }

    @Deactivate
    private void deactivate() {
        for (String manuallyRegisteredMetric : MANUALLY_REGISTERED_METRICS) {
            this.metricRegistry.remove(manuallyRegisteredMetric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getQuery(@NotNull String hash, @NotNull String resourceType, @Nullable String selectorString) {
        this.readLock.lock();
        try {
            String string = (String)this.persistedQueriesCache.get(this.getCacheKey(hash, resourceType, selectorString));
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String cacheQuery(@NotNull String query, @NotNull String resourceType, @Nullable String selectorString) {
        this.writeLock.lock();
        try {
            String hash = this.getHash(query);
            String key = this.getCacheKey(hash, resourceType, selectorString);
            this.persistedQueriesCache.put(key, query);
            if (this.persistedQueriesCache.containsKey(key)) {
                String string = hash;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @NotNull
    private String getCacheKey(@NotNull String hash, @NotNull String resourceType, @Nullable String selectorString) {
        StringBuilder key = new StringBuilder(resourceType);
        if (StringUtils.isNotEmpty((CharSequence)selectorString)) {
            key.append("_").append(selectorString);
        }
        key.append("_").append(hash);
        return key.toString();
    }

    @NotNull
    String getHash(@NotNull String query) {
        StringBuilder buffer = new StringBuilder();
        try {
            byte[] hash;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (byte b : hash = digest.digest(query.getBytes(StandardCharsets.UTF_8))) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SlingGraphQLException("Failed hashing query - " + e.getMessage());
        }
        return buffer.toString();
    }

    private class InMemoryLRUCache
    extends LinkedHashMap<String, String> {
        private final int capacity;
        private final long maxSizeInBytes;
        private long currentSizeInBytes;

        public InMemoryLRUCache(int capacity, long maxSizeInBytes) {
            this.capacity = Math.max(capacity, 0);
            this.maxSizeInBytes = Math.max(maxSizeInBytes, 0L);
            this.currentSizeInBytes = 0L;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            boolean willRemove = false;
            if (this.capacity > 0) {
                willRemove = this.size() > this.capacity;
            } else if (this.maxSizeInBytes > 0L) {
                boolean bl = willRemove = this.currentSizeInBytes > this.maxSizeInBytes;
            }
            if (willRemove) {
                SimpleGraphQLCacheProvider.this.evictions.increment();
                this.currentSizeInBytes -= (long)this.getApproximateStringSizeInBytes(eldest.getValue());
            }
            return willRemove;
        }

        @Override
        public String put(String key, String value) {
            long valueSize = this.getApproximateStringSizeInBytes(value);
            if (this.capacity <= 0 && this.maxSizeInBytes > 0L) {
                long newSizeInBytes;
                boolean isReplacement = this.containsKey(key);
                if (isReplacement) {
                    long oldValueSize = this.getApproximateStringSizeInBytes((String)this.get(key));
                    newSizeInBytes = this.currentSizeInBytes - oldValueSize + valueSize;
                } else {
                    newSizeInBytes = this.currentSizeInBytes + valueSize;
                    Optional head = this.values().stream().findFirst();
                    if (head.isPresent()) {
                        newSizeInBytes -= (long)this.getApproximateStringSizeInBytes((String)head.get());
                    }
                }
                if (newSizeInBytes <= this.maxSizeInBytes) {
                    this.currentSizeInBytes = isReplacement ? newSizeInBytes : (this.currentSizeInBytes += valueSize);
                    return super.put(key, value);
                }
            } else {
                this.currentSizeInBytes += valueSize;
                return super.put(key, value);
            }
            return null;
        }

        int getApproximateStringSizeInBytes(@NotNull String string) {
            return 8 * ((string.length() * 2 + 45) / 8);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InMemoryLRUCache) {
                InMemoryLRUCache other = (InMemoryLRUCache)obj;
                return Objects.equals(this.capacity, other.capacity) && Objects.equals(this.maxSizeInBytes, other.maxSizeInBytes) && Objects.equals(this.currentSizeInBytes, other.currentSizeInBytes) && super.equals(obj);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.capacity + (int)(this.maxSizeInBytes + this.currentSizeInBytes);
        }
    }

    @ObjectClassDefinition(name="Apache Sling GraphQL Simple Cache Provider", description="The Apache Sling GraphQL Simple Cache Provider provides an in-memory size bound cache for persisted GraphQL queries.")
    public static @interface Config {
        @AttributeDefinition(name="Capacity", description="The number of persisted queries to cache. If the cache size is set to a number greater than 0, then this parameter will have priority over maxMemory.", type=AttributeType.INTEGER, min="0")
        public int cacheSize() default 0;

        @AttributeDefinition(name="Max Values in Bytes", description="The maximum amount of memory the values stored in the cache can use.")
        public long maxMemory() default 0xA00000L;
    }
}

