/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.graphql.core.json.JsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryParser {
    private static final String MIME_TYPE_JSON = "application/json";
    private static final JsonSerializer jsonSerializer = new JsonSerializer();
    private static final String JSON_KEY_QUERY = "query";
    private static final String JSON_KEY_VARIABLES = "variables";

    private QueryParser() {
    }

    @Nullable
    public static Result fromRequest(@NotNull SlingHttpServletRequest request) throws IOException {
        String query = null;
        Map variables = null;
        if (request.getMethod().equalsIgnoreCase("POST") && MIME_TYPE_JSON.equals(request.getContentType())) {
            Map<String, Object> requestJson = QueryParser.getInputJson(request);
            query = (String)requestJson.get(JSON_KEY_QUERY);
            if (query != null) {
                query = query.replace("\\n", "\n");
            }
            variables = (Map)requestJson.get(JSON_KEY_VARIABLES);
        }
        if (query == null) {
            query = request.getParameter(JSON_KEY_QUERY);
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        if (query != null) {
            return new Result(query, variables);
        }
        return null;
    }

    public static Result fromJSON(String json) throws IOException {
        Map<String, Object> jsonMap = jsonSerializer.jsonToMaps(IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8));
        String query = (String)jsonMap.get(JSON_KEY_QUERY);
        if (query != null) {
            Map<String, Object> variables = (Map<String, Object>)jsonMap.get(JSON_KEY_VARIABLES);
            if (variables == null) {
                variables = Collections.emptyMap();
            }
            return new Result(query, variables);
        }
        throw new IOException("The provided JSON structure does not contain a query.");
    }

    private static Map<String, Object> getInputJson(SlingHttpServletRequest req) throws IOException {
        return jsonSerializer.jsonToMaps((InputStream)new ReaderInputStream((Reader)req.getReader()));
    }

    static class Result {
        private final String query;
        private final Map<String, Object> variables;

        Result(String query, Map<String, Object> variables) {
            this.query = query;
            this.variables = variables;
        }

        @NotNull
        public String getQuery() {
            return this.query;
        }

        @NotNull
        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

