/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.json;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import graphql.ExecutionResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.WriterOutputStream;

public class JsonSerializer {
    public static final Map<String, Object> WRITER_OPTIONS;

    public void sendJSON(Writer out, ExecutionResult result) throws IOException {
        Map data = result.toSpecification();
        if (data == null) {
            throw new IOException("No data");
        }
        try (JsonWriter w = new JsonWriter((OutputStream)new WriterOutputStream(out), WRITER_OPTIONS);){
            w.write((Object)data);
        }
    }

    public String toJSON(Object data) {
        return JsonWriter.objectToJson((Object)data, WRITER_OPTIONS);
    }

    public Map<String, Object> jsonToMaps(InputStream input) {
        return JsonReader.jsonToMaps((InputStream)input, null);
    }

    static {
        HashMap<String, Boolean> writerOptions = new HashMap<String, Boolean>();
        writerOptions.put("TYPE", false);
        WRITER_OPTIONS = Collections.unmodifiableMap(writerOptions);
    }
}

