/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.core.engine.SlingScriptWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ScriptedDataFetcherProvider.class})
public class ScriptedDataFetcherProvider {
    public static final String SCRIPT_NAME = "fetcher";
    public static final String FAKE_RESOURCE_TYPE_PREFIX = "graphql/fetchers/";
    @Reference
    private ServletResolver servletResolver;

    @Nullable
    SlingDataFetcher<Object> getDataFetcher(@NotNull String name) {
        FakeResource r = new FakeResource(FAKE_RESOURCE_TYPE_PREFIX + name);
        Servlet s = this.servletResolver.resolveServlet((Resource)r, SCRIPT_NAME);
        if (s instanceof SlingScript) {
            return new SlingScriptWrapper((SlingScript)s);
        }
        return null;
    }

    private static class FakeResource
    extends AbstractResource {
        private final String resourceType;

        FakeResource(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getPath() {
            return "FAKE_RESOURCE_PATH";
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getResourceSuperType() {
            return null;
        }

        public ResourceMetadata getResourceMetadata() {
            throw new UnsupportedOperationException("Shouldn't be needed");
        }

        public ResourceResolver getResourceResolver() {
            throw new UnsupportedOperationException("Shouldn't be needed");
        }
    }
}

