/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.servlet;

import graphql.ExecutionResult;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.graphql.core.engine.GraphQLResourceQuery;
import org.apache.sling.graphql.core.engine.SlingDataFetcherSelector;
import org.apache.sling.graphql.core.json.JsonSerializer;
import org.apache.sling.graphql.core.scalars.SlingScalarsProvider;
import org.apache.sling.graphql.core.schema.RankedSchemaProviders;
import org.apache.sling.graphql.core.servlet.RequestParser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, name="org.apache.sling.graphql.core.GraphQLServlet", immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Sling GraphQL Servlet", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class, factory=true)
public class GraphQLServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String P_QUERY = "query";
    @Reference
    private RankedSchemaProviders schemaProviders;
    @Reference
    private SlingDataFetcherSelector dataFetcherSelector;
    @Reference
    private SlingScalarsProvider scalarsProvider;
    private final JsonSerializer jsonSerializer = new JsonSerializer();

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.execute(request.getResource(), request, response);
    }

    public void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.execute(request.getResource(), request, response);
    }

    private void execute(Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        RequestParser parser = new RequestParser(request);
        String query = parser.getQuery();
        if (query == null || query.trim().length() == 0) {
            response.sendError(400, "Missing request parameter:query");
            return;
        }
        try {
            GraphQLResourceQuery q = new GraphQLResourceQuery();
            ExecutionResult result = q.executeQuery(this.schemaProviders, this.dataFetcherSelector, this.scalarsProvider, resource, request.getRequestPathInfo().getSelectors(), query, parser.getVariables());
            this.jsonSerializer.sendJSON(response.getWriter(), result);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            response.getWriter().flush();
        }
    }

    @ObjectClassDefinition(name="Apache Sling GraphQL Servlet", description="Servlet that implements GraphQL endpoints")
    public static @interface Config {
        @AttributeDefinition(name="Selectors", description="Standard Sling servlet property")
        public String[] sling_servlet_selectors() default {""};

        @AttributeDefinition(name="Resource Types", description="Standard Sling servlet property")
        public String[] sling_servlet_resourceTypes() default {"sling/servlet/default"};

        @AttributeDefinition(name="Methods", description="Standard Sling servlet property")
        public String[] sling_servlet_methods() default {"GET"};

        @AttributeDefinition(name="Extensions", description="Standard Sling servlet property")
        public String[] sling_servlet_extensions() default {"gql"};
    }
}

